/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.time.Duration;
import java.util.Collection;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableInsertByIdOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveInsertByIdOperationSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.util.Assert;

public class ExecutableInsertByIdOperationSupport
implements ExecutableInsertByIdOperation {
    private final CouchbaseTemplate template;

    public ExecutableInsertByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableInsertByIdOperation.ExecutableInsertById<T> insertById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableInsertByIdSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, null);
    }

    static class ExecutableInsertByIdSupport<T>
    implements ExecutableInsertByIdOperation.ExecutableInsertById<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final InsertOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final ReactiveInsertByIdOperationSupport.ReactiveInsertByIdSupport<T> reactiveSupport;

        ExecutableInsertByIdSupport(CouchbaseTemplate template, Class<T> domainType, String scope, String collection, InsertOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.reactiveSupport = new ReactiveInsertByIdOperationSupport.ReactiveInsertByIdSupport<T>(template.reactive(), domainType, scope, collection, options, persistTo, replicateTo, durabilityLevel, expiry, new NonReactiveSupportWrapper(template.support()));
        }

        @Override
        public T one(T object) {
            return (T)this.reactiveSupport.one(object).block();
        }

        @Override
        public Collection<? extends T> all(Collection<? extends T> objects) {
            return (Collection)this.reactiveSupport.all(objects).collectList().block();
        }

        @Override
        public ExecutableInsertByIdOperation.TerminatingInsertById<T> withOptions(InsertOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableInsertByIdOperation.InsertByIdInCollection<T> inScope(String scope) {
            return new ExecutableInsertByIdSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableInsertByIdOperation.InsertByIdWithOptions<T> inCollection(String collection) {
            return new ExecutableInsertByIdSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableInsertByIdOperation.InsertByIdInScope<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ExecutableInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableInsertByIdOperation.InsertByIdInScope<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ExecutableInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableInsertByIdOperation.InsertByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ExecutableInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry);
        }
    }
}

