/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.transactions.internal.ConverterUtil;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperation;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveRemoveByIdOperationSupport
implements ReactiveRemoveByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveRemoveByIdOperationSupport.class);

    public ReactiveRemoveByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    @Deprecated
    public ReactiveRemoveByIdOperation.ReactiveRemoveById removeById() {
        return this.removeById(null);
    }

    @Override
    public ReactiveRemoveByIdOperation.ReactiveRemoveById removeById(Class<?> domainType) {
        return new ReactiveRemoveByIdSupport(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, null);
    }

    static class ReactiveRemoveByIdSupport
    implements ReactiveRemoveByIdOperation.ReactiveRemoveById {
        private final ReactiveCouchbaseTemplate template;
        private final Class<?> domainType;
        private final String scope;
        private final String collection;
        private final RemoveOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Long cas;

        ReactiveRemoveByIdSupport(ReactiveCouchbaseTemplate template, Class<?> domainType, String scope, String collection, RemoveOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Long cas) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.cas = cas;
        }

        @Override
        public Mono<RemoveResult> one(Object id) {
            PseudoArgs<RemoveOptions> pArgs = new PseudoArgs<RemoveOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("removeById key={} {}", id, pArgs);
            }
            CouchbaseClientFactory clientFactory = this.template.getCouchbaseClientFactory();
            ReactiveCollection rc = clientFactory.withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive();
            return TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMap(s -> {
                if (!s.isPresent()) {
                    return rc.remove(id.toString(), this.buildRemoveOptions((RemoveOptions)pArgs.getOptions())).map(r -> RemoveResult.from(id.toString(), r));
                }
                this.rejectInvalidTransactionalOptions();
                if (this.cas == null || this.cas == 0L) {
                    throw new IllegalArgumentException("cas must be supplied for tx remove");
                }
                CoreTransactionAttemptContext ctx = ((CouchbaseResourceHolder)((Object)((Object)s.get()))).getCore();
                Mono gr = ctx.get(ConverterUtil.makeCollectionIdentifier((AsyncCollection)rc.async()), id.toString());
                return gr.flatMap(getResult -> {
                    if (getResult.cas() != this.cas.longValue()) {
                        return Mono.error((Throwable)TransactionalSupport.retryTransactionOnCasMismatch(ctx, getResult.cas(), this.cas));
                    }
                    CoreTransactionAttemptContext internal = ctx;
                    RequestSpan span = CbTracing.newSpan((CoreContext)internal.core().context(), (String)"transaction_remove", (RequestSpan)internal.span());
                    span.attribute("db.operation", "transaction_remove");
                    return ctx.remove(getResult, new SpanWrapper(span)).map(r -> new RemoveResult(id.toString(), 0L, null));
                });
            }).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        private void rejectInvalidTransactionalOptions() {
            if (this.persistTo != null && this.persistTo != PersistTo.NONE || this.replicateTo != null && this.replicateTo != ReplicateTo.NONE) {
                throw new IllegalArgumentException("withDurability PersistTo and ReplicateTo overload is not supported in a transaction");
            }
            if (this.durabilityLevel != null && this.durabilityLevel != DurabilityLevel.NONE) {
                throw new IllegalArgumentException("withDurability is not supported in a transaction");
            }
            if (this.options != null) {
                throw new IllegalArgumentException("withOptions is not supported in a transaction");
            }
        }

        @Override
        public Mono<RemoveResult> oneEntity(Object entity) {
            ReactiveRemoveByIdSupport op = new ReactiveRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.template.support().getCas(entity));
            return op.one(this.template.support().getId(entity).toString());
        }

        @Override
        public Flux<RemoveResult> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::one);
        }

        @Override
        public Flux<RemoveResult> allEntities(Collection<Object> entities) {
            return Flux.fromIterable(entities).flatMap(this::oneEntity);
        }

        private RemoveOptions buildRemoveOptions(RemoveOptions options) {
            return OptionsBuilder.buildRemoveOptions(options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdInScope withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdInScope withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdWithDurability inCollection(String collection) {
            return new ReactiveRemoveByIdSupport(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdInCollection inScope(String scope) {
            return new ReactiveRemoveByIdSupport(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.TerminatingRemoveById withOptions(RemoveOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdWithDurability withCas(Long cas) {
            return new ReactiveRemoveByIdSupport(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, cas);
        }
    }
}

