/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import java.lang.reflect.InaccessibleObjectException;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.join.N1qlJoinResolver;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.event.AfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.ClassUtils;

@Stability.Internal
public abstract class AbstractTemplateSupport {
    final ReactiveCouchbaseTemplate template;
    final CouchbaseConverter converter;
    final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    final TranslationService translationService;
    ApplicationContext applicationContext;
    static final Logger LOG = LoggerFactory.getLogger(AbstractTemplateSupport.class);

    public AbstractTemplateSupport(ReactiveCouchbaseTemplate template, CouchbaseConverter converter, TranslationService translationService) {
        this.template = template;
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.translationService = translationService;
    }

    abstract ReactiveCouchbaseTemplate getReactiveTemplate();

    public <T> T decodeEntityBase(Object id, String source, Long cas, Instant expiryTime, Class<T> entityClass, String scope, String collection, Object txResultHolder, CouchbaseResourceHolder holder) {
        CouchbasePersistentEntity persistentEntity = this.couldBePersistentEntity(entityClass);
        if (persistentEntity == null) {
            CouchbaseDocument converted = new CouchbaseDocument(id);
            Set<Map.Entry<String, Object>> set = ((CouchbaseDocument)this.translationService.decode(source, converted)).getContent().entrySet();
            return (T)set.iterator().next().getValue();
        }
        if (id == null) {
            throw new CouchbaseException("__id was null. Either use #{#n1ql.selectEntity} or project __id");
        }
        CouchbaseDocument converted = new CouchbaseDocument(id);
        if (persistentEntity.getVersionProperty() != null) {
            if (cas == null) {
                throw new CouchbaseException("version/cas in the entity but __cas was not in result. Either use #{#n1ql.selectEntity} or project __cas");
            }
            if (cas != 0L) {
                converted.put(persistentEntity.getVersionProperty().getName(), cas);
            }
        }
        Object readEntity = this.converter.read(entityClass, (CouchbaseDocument)this.translationService.decode(source, converted));
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(readEntity);
        persistentEntity = this.couldBePersistentEntity(readEntity.getClass());
        if (cas != null && cas != 0L && persistentEntity.getVersionProperty() != null) {
            accessor.setProperty(persistentEntity.getVersionProperty(), (Object)cas);
        }
        if (expiryTime != null && persistentEntity.getExpiryProperty() != null) {
            accessor.setProperty((PersistentProperty)persistentEntity.getExpiryProperty(), (Object)expiryTime);
        }
        N1qlJoinResolver.handleProperties(persistentEntity, accessor, this.getReactiveTemplate(), id.toString(), scope, collection);
        if (holder != null) {
            holder.transactionResultHolder(txResultHolder, accessor.getBean());
        }
        return (T)accessor.getBean();
    }

    CouchbasePersistentEntity couldBePersistentEntity(Class<?> entityClass) {
        if (ClassUtils.isPrimitiveOrWrapper(entityClass) || entityClass == String.class) {
            return null;
        }
        try {
            return (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            return null;
        }
    }

    public <T> T applyResultBase(T entity, CouchbaseDocument converted, Object id, long cas, Object txResultHolder, CouchbaseResourceHolder holder) {
        CouchbasePersistentProperty versionProperty;
        ConvertingPropertyAccessor<T> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null) {
            accessor.setProperty((PersistentProperty)idProperty, id);
        }
        if ((versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty()) != null) {
            accessor.setProperty((PersistentProperty)versionProperty, (Object)cas);
        }
        if (holder != null) {
            holder.transactionResultHolder(txResultHolder, accessor.getBean());
        }
        this.maybeEmitEvent(new AfterSaveEvent<Object>(accessor.getBean(), converted));
        return (T)accessor.getBean();
    }

    public Long getCas(Object entity) {
        Object casObject;
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        long cas = 0L;
        if (versionProperty != null && (casObject = accessor.getProperty((PersistentProperty)versionProperty)) instanceof Number) {
            cas = ((Number)casObject).longValue();
        }
        return cas;
    }

    public Object getId(Object entity) {
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
        CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)persistentEntity.getIdProperty();
        Object id = null;
        if (idProperty != null) {
            id = accessor.getProperty((PersistentProperty)idProperty);
        }
        return id;
    }

    public String getJavaNameForEntity(Class<?> clazz) {
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
        MappingCouchbaseEntityInformation info = new MappingCouchbaseEntityInformation(persistentEntity);
        return info.getJavaType().getName();
    }

    <T> ConvertingPropertyAccessor<T> getPropertyAccessor(T source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    public void maybeEmitEvent(CouchbaseMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            try {
                this.applicationContext.publishEvent(event);
            }
            catch (Exception e) {
                LOG.warn("{} thrown during {}", (Object)e, event);
                throw e;
            }
        } else {
            LOG.info("maybeEmitEvent called, but CouchbaseTemplate not initialized with applicationContext");
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    public TranslationService getTranslationService() {
        return this.translationService;
    }
}

