/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.kv.ScanOptions;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableRangeScanOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveRangeScanOperationSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;

public class ExecutableRangeScanOperationSupport
implements ExecutableRangeScanOperation {
    private final CouchbaseTemplate template;

    ExecutableRangeScanOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableRangeScanOperation.ExecutableRangeScan<T> rangeScan(Class<T> domainType) {
        return new ExecutableRangeScanSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, null, null, null, null);
    }

    static class ExecutableRangeScanSupport<T>
    implements ExecutableRangeScanOperation.ExecutableRangeScan<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final ScanOptions options;
        private final Object sort;
        private final MutationState mutationState;
        private final Integer batchItemLimit;
        private final Integer batchByteLimit;
        private final ReactiveRangeScanOperationSupport.ReactiveRangeScanSupport<T> reactiveSupport;

        ExecutableRangeScanSupport(CouchbaseTemplate template, Class<T> domainType, String scope, String collection, ScanOptions options, Object sort, MutationState mutationState, Integer batchItemLimit, Integer batchByteLimit) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.sort = sort;
            this.mutationState = mutationState;
            this.batchItemLimit = batchItemLimit;
            this.batchByteLimit = batchByteLimit;
            this.reactiveSupport = new ReactiveRangeScanOperationSupport.ReactiveRangeScanSupport<T>(template.reactive(), domainType, scope, collection, options, sort, mutationState, batchItemLimit, batchByteLimit, new NonReactiveSupportWrapper(template.support()));
        }

        @Override
        public ExecutableRangeScanOperation.TerminatingRangeScan<T> withOptions(ScanOptions options) {
            return new ExecutableRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, options != null ? options : this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit);
        }

        @Override
        public ExecutableRangeScanOperation.RangeScanWithOptions<T> inCollection(String collection) {
            return new ExecutableRangeScanSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit);
        }

        @Override
        public ExecutableRangeScanOperation.RangeScanInCollection<T> inScope(String scope) {
            return new ExecutableRangeScanSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit);
        }

        @Override
        public ExecutableRangeScanOperation.RangeScanInScope<T> withSort(Object sort) {
            return new ExecutableRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, sort, this.mutationState, this.batchItemLimit, this.batchByteLimit);
        }

        @Override
        public ExecutableRangeScanOperation.RangeScanWithSort<T> consistentWith(MutationState mutationState) {
            return new ExecutableRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.sort, mutationState, this.batchItemLimit, this.batchByteLimit);
        }

        @Override
        public <R> ExecutableRangeScanOperation.RangeScanConsistentWith<R> as(Class<R> returnType) {
            return new ExecutableRangeScanSupport<R>(this.template, returnType, this.scope, this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, this.batchByteLimit);
        }

        @Override
        public ExecutableRangeScanOperation.RangeScanWithProjection<T> withBatchItemLimit(Integer batchItemLimit) {
            return new ExecutableRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.sort, this.mutationState, batchItemLimit, this.batchByteLimit);
        }

        @Override
        public ExecutableRangeScanOperation.RangeScanWithBatchItemLimit<T> withBatchByteLimit(Integer batchByteLimit) {
            return new ExecutableRangeScanSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.sort, this.mutationState, this.batchItemLimit, batchByteLimit);
        }

        @Override
        public Stream<T> rangeScan(String lower, String upper) {
            return this.reactiveSupport.rangeScan(lower, upper, false, null, null).toStream();
        }

        @Override
        public Stream<String> rangeScanIds(String lower, String upper) {
            return this.reactiveSupport.rangeScanIds(lower, upper, false, null, null).toStream();
        }

        @Override
        public Stream<T> samplingScan(Long limit, Long ... seed) {
            return this.reactiveSupport.sampleScan(limit, seed).toStream();
        }

        @Override
        public Stream<String> samplingScanIds(Long limit, Long ... seed) {
            return this.reactiveSupport.sampleScanIds(limit, seed).toStream();
        }
    }
}

