/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.config.admin.GemfireAdminOperations;
import org.springframework.data.gemfire.config.admin.remote.FunctionGemfireAdminTemplate;
import org.springframework.data.gemfire.config.admin.remote.RestHttpGemfireAdminTemplate;
import org.springframework.data.gemfire.config.annotation.EnableClusterConfiguration;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.schema.SchemaObjectCollector;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefiner;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.data.gemfire.config.schema.support.ClientRegionCollector;
import org.springframework.data.gemfire.config.schema.support.ComposableSchemaObjectCollector;
import org.springframework.data.gemfire.config.schema.support.ComposableSchemaObjectDefiner;
import org.springframework.data.gemfire.config.schema.support.IndexCollector;
import org.springframework.data.gemfire.config.schema.support.IndexDefiner;
import org.springframework.data.gemfire.config.schema.support.RegionDefiner;
import org.springframework.data.gemfire.util.CacheUtils;

@Configuration
public class ClusterConfigurationConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final boolean DEFAULT_MANAGEMENT_USE_HTTP = false;
    protected static final int DEFAULT_MANAGEMENT_HTTP_PORT = 7070;
    protected static final String DEFAULT_MANAGEMENT_HTTP_HOST = "localhost";
    private static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = RegionDefinition.DEFAULT_REGION_SHORTCUT;
    private Boolean useHttp = false;
    private Integer managementHttpPort = 7070;
    private RegionShortcut serverRegionShortcut;
    private String managementHttpHost = "localhost";

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableClusterConfiguration.class;
    }

    protected void setManagementHttpHost(String hostname) {
        this.managementHttpHost = hostname;
    }

    protected Optional<String> getManagementHttpHost() {
        return Optional.ofNullable(this.managementHttpHost);
    }

    protected String resolveManagementHttpHost() {
        return this.getManagementHttpHost().orElse(DEFAULT_MANAGEMENT_HTTP_HOST);
    }

    protected void setManagementHttpPort(Integer managementHttpPort) {
        this.managementHttpPort = managementHttpPort;
    }

    protected Optional<Integer> getManagementHttpPort() {
        return Optional.ofNullable(this.managementHttpPort);
    }

    protected int resolveManagementHttpPort() {
        return this.getManagementHttpPort().orElse(7070);
    }

    protected void setManagementUseHttp(Boolean useHttp) {
        this.useHttp = useHttp;
    }

    protected Optional<Boolean> getManagementUseHttp() {
        return Optional.ofNullable(this.useHttp);
    }

    protected boolean resolveManagementUseHttp() {
        return this.getManagementUseHttp().orElse(false);
    }

    protected void setServerRegionShortcut(RegionShortcut regionShortcut) {
        this.serverRegionShortcut = regionShortcut;
    }

    protected Optional<RegionShortcut> getServerRegionShortcut() {
        return Optional.ofNullable(this.serverRegionShortcut);
    }

    protected RegionShortcut resolveServerRegionShortcut() {
        return this.getServerRegionShortcut().orElse(DEFAULT_SERVER_REGION_SHORTCUT);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableClusterConfigurationAttributes = this.getAnnotationAttributes(importMetadata);
            this.setManagementHttpHost(this.resolveProperty(this.managementProperty("http.host"), enableClusterConfigurationAttributes.getString("host")));
            this.setManagementHttpPort(this.resolveProperty(this.managementProperty("http.port"), (Integer)enableClusterConfigurationAttributes.getNumber("port")));
            this.setManagementUseHttp(this.resolveProperty(this.managementProperty("use-http"), enableClusterConfigurationAttributes.getBoolean("useHttp")));
            this.setServerRegionShortcut((RegionShortcut)this.resolveProperty(this.clusterProperty("region.type"), RegionShortcut.class, enableClusterConfigurationAttributes.getEnum("serverRegionShortcut")));
        }
    }

    @EventListener
    public void gemfireClusterSchemaCreationHandler(ContextRefreshedEvent event) {
        GemFireCache gemfireCache = this.resolveGemFireCache((ApplicationContextEvent)event);
        if (CacheUtils.isClient(gemfireCache)) {
            GemfireAdminOperations gemfireAdminOperations = this.newGemfireAdminOperations((ClientCache)gemfireCache);
            SchemaObjectDefiner schemaObjectDefiner = this.newSchemaObjectDefiner();
            Iterable<?> schemaObjects = this.newSchemaObjectCollector().collectFrom(this.resolveApplicationContext((ApplicationContextEvent)event));
            StreamSupport.stream(schemaObjects.spliterator(), false).map(schemaObjectDefiner::define).sorted((Comparator<Optional>)OrderComparator.INSTANCE).forEach(schemaObjectDefinition -> schemaObjectDefinition.ifPresent(it -> it.create(gemfireAdminOperations)));
        }
    }

    private ApplicationContext resolveApplicationContext(ApplicationContextEvent event) {
        return event.getApplicationContext();
    }

    private GemFireCache resolveGemFireCache(ApplicationContextEvent event) {
        try {
            return (GemFireCache)this.resolveApplicationContext(event).getBean(GemFireCache.class);
        }
        catch (BeansException ignore) {
            return GemfireUtils.resolveGemFireCache();
        }
    }

    private GemfireAdminOperations newGemfireAdminOperations(ClientCache clientCache) {
        if (this.resolveManagementUseHttp()) {
            String host = this.resolveManagementHttpHost();
            int port = this.resolveManagementHttpPort();
            return new RestHttpGemfireAdminTemplate(clientCache, host, port);
        }
        return new FunctionGemfireAdminTemplate(clientCache);
    }

    private SchemaObjectCollector<?> newSchemaObjectCollector() {
        return ComposableSchemaObjectCollector.compose(new ClientRegionCollector(), new IndexCollector());
    }

    private SchemaObjectDefiner newSchemaObjectDefiner() {
        return ComposableSchemaObjectDefiner.compose(new RegionDefiner(this.resolveServerRegionShortcut()), new IndexDefiner());
    }
}

