/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.util.Assert;

class PoolServerFunctionExecution
extends AbstractFunctionExecution
implements InitializingBean {
    private Pool pool;
    private String poolname;

    public PoolServerFunctionExecution(Pool pool) {
        Assert.notNull((Object)pool, (String)"pool cannot be null");
        this.pool = pool;
    }

    public PoolServerFunctionExecution(String poolname) {
        Assert.notNull((Object)poolname, (String)"pool name cannot be null");
        this.poolname = poolname;
    }

    @Override
    protected Execution getExecution() {
        return FunctionService.onServer((Pool)this.pool);
    }

    public void afterPropertiesSet() throws Exception {
        this.pool = PoolManager.find((String)this.poolname);
        Assert.notNull((Object)this.pool, (String)(" pool " + this.poolname + " does not exist"));
    }
}

