/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.ContextProvider;
import com.mongodb.RequestContext;
import com.mongodb.client.SynchronousContextProvider;
import com.mongodb.reactivestreams.client.ReactiveContextProvider;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import org.springframework.data.core.ReactiveWrappers;
import org.springframework.data.mongodb.observability.MapRequestContext;
import org.springframework.util.ClassUtils;
import reactor.core.CoreSubscriber;

public class ContextProviderFactory {
    private static final boolean SYNCHRONOUS_PRESENT = ClassUtils.isPresent((String)"com.mongodb.client.SynchronousContextProvider", (ClassLoader)ContextProviderFactory.class.getClassLoader());
    private static final boolean REACTIVE_PRESENT = ClassUtils.isPresent((String)"com.mongodb.reactivestreams.client.ReactiveContextProvider", (ClassLoader)ContextProviderFactory.class.getClassLoader()) && ReactiveWrappers.isAvailable((ReactiveWrappers.ReactiveLibrary)ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR);

    public static ContextProvider create(ObservationRegistry observationRegistry) {
        if (SYNCHRONOUS_PRESENT && REACTIVE_PRESENT) {
            return new CompositeContextProvider(observationRegistry);
        }
        if (SYNCHRONOUS_PRESENT) {
            return new DefaultSynchronousContextProvider(observationRegistry);
        }
        if (REACTIVE_PRESENT) {
            return DefaultReactiveContextProvider.INSTANCE;
        }
        throw new IllegalStateException("Cannot create ContextProvider. Neither SynchronousContextProvider nor ReactiveContextProvider is on the class path.");
    }

    record CompositeContextProvider(DefaultSynchronousContextProvider synchronousContextProvider) implements SynchronousContextProvider,
    ReactiveContextProvider
    {
        CompositeContextProvider(ObservationRegistry observationRegistry) {
            this(new DefaultSynchronousContextProvider(observationRegistry));
        }

        public RequestContext getContext() {
            return this.synchronousContextProvider.getContext();
        }

        public RequestContext getContext(Subscriber<?> subscriber) {
            return DefaultReactiveContextProvider.INSTANCE.getContext(subscriber);
        }
    }

    record DefaultSynchronousContextProvider(ObservationRegistry observationRegistry) implements SynchronousContextProvider
    {
        public RequestContext getContext() {
            MapRequestContext requestContext = new MapRequestContext();
            Observation currentObservation = this.observationRegistry.getCurrentObservation();
            if (currentObservation != null) {
                requestContext.put("micrometer.observation", currentObservation);
            }
            return requestContext;
        }
    }

    static enum DefaultReactiveContextProvider implements ReactiveContextProvider
    {
        INSTANCE;


        public RequestContext getContext(Subscriber<?> subscriber) {
            if (subscriber instanceof CoreSubscriber) {
                CoreSubscriber cs = (CoreSubscriber)subscriber;
                Map map = cs.currentContext().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
                return new MapRequestContext(map);
            }
            return new MapRequestContext();
        }
    }
}

