/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.BitPipelineBinaryCommands;
import redis.clients.jedis.commands.StringPipelineBinaryCommands;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.SetParams;

@NullUnmarked
class JedisStringCommands
implements RedisStringCommands {
    private final JedisConnection connection;

    JedisStringCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] get(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::get, StringPipelineBinaryCommands::get, key);
    }

    @Override
    public byte[] getDel(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::getDel, StringPipelineBinaryCommands::getDel, key);
    }

    @Override
    public byte[] getEx(byte @NonNull [] key, @NonNull Expiration expiration) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        return this.connection.invoke().just(Jedis::getEx, StringPipelineBinaryCommands::getEx, key, JedisConverters.toGetExParams(expiration));
    }

    @Override
    public byte[] getSet(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just(Jedis::getSet, StringPipelineBinaryCommands::getSet, key, value);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::mget, StringPipelineBinaryCommands::mget, keys);
    }

    @Override
    public Boolean set(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(Jedis::set, StringPipelineBinaryCommands::set, key, value).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean set(byte @NonNull [] key, byte @NonNull [] value, @NonNull Expiration expiration, @NonNull RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        Assert.notNull((Object)((Object)option), (String)"Option must not be null");
        SetParams params = JedisConverters.toSetCommandExPxArgument(expiration, JedisConverters.toSetCommandNxXxArgument(option));
        return this.connection.invoke().from(Jedis::set, StringPipelineBinaryCommands::set, key, value, params).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public byte @Nullable [] setGet(byte @NonNull [] key, byte @NonNull [] value, @NonNull Expiration expiration, @NonNull RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        Assert.notNull((Object)((Object)option), (String)"Option must not be null");
        SetParams params = JedisConverters.toSetCommandExPxArgument(expiration, JedisConverters.toSetCommandNxXxArgument(option));
        return this.connection.invoke().just(Jedis::setGet, StringPipelineBinaryCommands::setGet, key, value, params);
    }

    @Override
    public Boolean setNX(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(Jedis::setnx, StringPipelineBinaryCommands::setnx, key, value).get(Converters.longToBoolean());
    }

    @Override
    public Boolean setEx(byte @NonNull [] key, long seconds, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Time must be less than Integer.MAX_VALUE for setEx in Jedis");
        }
        return this.connection.invoke().from(Jedis::setex, StringPipelineBinaryCommands::setex, key, seconds, value).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean pSetEx(byte @NonNull [] key, long milliseconds, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(Jedis::psetex, StringPipelineBinaryCommands::psetex, key, milliseconds, value).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean mSet(@NonNull Map<byte @NonNull [], byte @NonNull []> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null");
        return this.connection.invoke().from(Jedis::mset, StringPipelineBinaryCommands::mset, JedisConverters.toByteArrays(tuples)).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean mSetNX(@NonNull Map<byte @NonNull [], byte @NonNull []> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null");
        return this.connection.invoke().from(Jedis::msetnx, StringPipelineBinaryCommands::msetnx, JedisConverters.toByteArrays(tuples)).get(Converters.longToBoolean());
    }

    @Override
    public Long incr(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::incr, StringPipelineBinaryCommands::incr, key);
    }

    @Override
    public Long incrBy(byte @NonNull [] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::incrBy, StringPipelineBinaryCommands::incrBy, key, value);
    }

    @Override
    public Double incrBy(byte @NonNull [] key, double value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::incrByFloat, StringPipelineBinaryCommands::incrByFloat, key, value);
    }

    @Override
    public Long decr(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::decr, StringPipelineBinaryCommands::decr, key);
    }

    @Override
    public Long decrBy(byte @NonNull [] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::decrBy, StringPipelineBinaryCommands::decrBy, key, value);
    }

    @Override
    public Long append(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just(Jedis::append, StringPipelineBinaryCommands::append, key, value);
    }

    @Override
    public byte[] getRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::getrange, StringPipelineBinaryCommands::getrange, key, start, end);
    }

    @Override
    public void setRange(byte @NonNull [] key, byte @NonNull [] value, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.connection.invokeStatus().just(Jedis::setrange, StringPipelineBinaryCommands::setrange, key, offset, value);
    }

    @Override
    public Boolean getBit(byte @NonNull [] key, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::getbit, BitPipelineBinaryCommands::getbit, key, offset);
    }

    @Override
    public Boolean setBit(byte @NonNull [] key, long offset, boolean value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::setbit, BitPipelineBinaryCommands::setbit, key, offset, value);
    }

    @Override
    public Long bitCount(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::bitcount, BitPipelineBinaryCommands::bitcount, key);
    }

    @Override
    public Long bitCount(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::bitcount, BitPipelineBinaryCommands::bitcount, key, start, end);
    }

    @Override
    public List<Long> bitField(byte @NonNull [] key, @NonNull BitFieldSubCommands subCommands) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)subCommands, (String)"Command must not be null");
        return this.connection.invoke().just(Jedis::bitfield, BitPipelineBinaryCommands::bitfield, key, JedisConverters.toBitfieldCommandArguments(subCommands));
    }

    @Override
    public Long bitOp(@NonNull RedisStringCommands.BitOperation op, byte @NonNull [] destination, byte[] ... keys) {
        Assert.notNull((Object)((Object)op), (String)"BitOperation must not be null");
        Assert.notNull((Object)destination, (String)"Destination key must not be null");
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new IllegalArgumentException("Bitop NOT should only be performed against one key");
        }
        return this.connection.invoke().just(Jedis::bitop, BitPipelineBinaryCommands::bitop, JedisConverters.toBitOp(op), destination, keys);
    }

    @Override
    public Long bitPos(byte @NonNull [] key, boolean bit, @NonNull Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null Use Range.unbounded() instead");
        if (range.getLowerBound().isBounded()) {
            Optional lower = range.getLowerBound().getValue();
            Range.Bound upper = range.getUpperBound();
            BitPosParams params = upper.isBounded() ? new BitPosParams(((Long)lower.get()).longValue(), ((Long)upper.getValue().get()).longValue()) : new BitPosParams(((Long)lower.get()).longValue());
            return this.connection.invoke().just(Jedis::bitpos, BitPipelineBinaryCommands::bitpos, key, bit, params);
        }
        return this.connection.invoke().just(Jedis::bitpos, BitPipelineBinaryCommands::bitpos, key, bit);
    }

    @Override
    public Long strLen(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::strlen, StringPipelineBinaryCommands::strlen, key);
    }
}

