/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslVerifyMode;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.resource.ClientResources;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisSocketConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.RedisStaticMasterReplicaConfiguration;
import org.springframework.data.redis.connection.lettuce.ClusterConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceClusterTopologyProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettucePoolingConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceSentinelConnection;
import org.springframework.data.redis.connection.lettuce.RedisCredentialsProviderFactory;
import org.springframework.data.redis.connection.lettuce.StandaloneConnectionProvider;
import org.springframework.data.redis.connection.lettuce.StaticMasterReplicaConnectionProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class LettuceConnectionFactory
implements RedisConnectionFactory,
ReactiveRedisConnectionFactory,
InitializingBean,
DisposableBean,
SmartLifecycle {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(LettuceExceptionConverter.INSTANCE);
    private int phase = 0;
    private boolean autoStartup = true;
    private boolean earlyStartup = true;
    private boolean convertPipelineAndTxResults = true;
    private boolean eagerInitialization = false;
    private boolean shareNativeConnection = true;
    private boolean validateConnection = false;
    private @Nullable AbstractRedisClient client;
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);
    private @Nullable ClusterCommandExecutor clusterCommandExecutor;
    private @Nullable AsyncTaskExecutor executor;
    private final LettuceClientConfiguration clientConfiguration;
    private @Nullable LettuceConnectionProvider connectionProvider;
    private @Nullable LettuceConnectionProvider reactiveConnectionProvider;
    private final Log log = LogFactory.getLog(this.getClass());
    private final Lock lock = new ReentrantLock();
    private LettuceConnection.PipeliningFlushPolicy pipeliningFlushPolicy = LettuceConnection.PipeliningFlushPolicy.flushEachCommand();
    private @Nullable RedisConfiguration configuration;
    private RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration("localhost", 6379);
    private @Nullable SharedConnection<byte[]> connection;
    private @Nullable SharedConnection<ByteBuffer> reactiveConnection;

    public LettuceConnectionFactory() {
        this(new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(String host, int port) {
        this(new RedisStandaloneConfiguration(host, port), (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    private LettuceConnectionFactory(LettuceClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"LettuceClientConfiguration must not be null");
        this.clientConfiguration = clientConfiguration;
        this.configuration = this.standaloneConfig;
    }

    public LettuceConnectionFactory(RedisConfiguration redisConfiguration) {
        this(redisConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisConfiguration redisConfiguration, LettuceClientConfiguration clientConfiguration) {
        this(clientConfiguration);
        Assert.notNull((Object)redisConfiguration, (String)"RedisConfiguration must not be null");
        this.configuration = redisConfiguration;
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfiguration) {
        this(clusterConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfiguration, LettuceClientConfiguration clientConfiguration) {
        this(clientConfiguration);
        Assert.notNull((Object)clusterConfiguration, (String)"RedisClusterConfiguration must not be null");
        this.configuration = clusterConfiguration;
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfiguration) {
        this(sentinelConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfiguration, LettuceClientConfiguration clientConfiguration) {
        this(clientConfiguration);
        Assert.notNull((Object)sentinelConfiguration, (String)"RedisSentinelConfiguration must not be null");
        this.configuration = sentinelConfiguration;
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration configuration) {
        this(configuration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration standaloneConfiguration, LettuceClientConfiguration clientConfiguration) {
        this(clientConfiguration);
        Assert.notNull((Object)standaloneConfiguration, (String)"RedisStandaloneConfiguration must not be null");
        this.standaloneConfig = standaloneConfiguration;
        this.configuration = this.standaloneConfig;
    }

    public static RedisConfiguration createRedisConfiguration(String redisUri) {
        Assert.hasText((String)redisUri, (String)"RedisURI must not be null or empty");
        return LettuceConnectionFactory.createRedisConfiguration(RedisURI.create((String)redisUri));
    }

    public static RedisConfiguration createRedisConfiguration(RedisURI redisUri) {
        Assert.notNull((Object)redisUri, (String)"RedisURI must not be null");
        if (!ObjectUtils.isEmpty((Object)redisUri.getSentinels())) {
            return LettuceConverters.createRedisSentinelConfiguration(redisUri);
        }
        if (!ObjectUtils.isEmpty((Object)redisUri.getSocket())) {
            return LettuceConverters.createRedisSocketConfiguration(redisUri);
        }
        return LettuceConverters.createRedisStandaloneConfiguration(redisUri);
    }

    ClusterCommandExecutor getRequiredClusterCommandExecutor() {
        Assert.state((this.clusterCommandExecutor != null ? 1 : 0) != 0, (String)"ClusterCommandExecutor not initialized");
        return this.clusterCommandExecutor;
    }

    public void setExecutor(AsyncTaskExecutor executor) {
        Assert.notNull((Object)executor, (String)"AsyncTaskExecutor must not be null");
        this.executor = executor;
    }

    public String getHostName() {
        return RedisConfiguration.getHostOrElse(this.configuration, this.standaloneConfig::getHostName);
    }

    @Deprecated
    public void setHostName(String hostName) {
        this.standaloneConfig.setHostName(hostName);
    }

    public int getPort() {
        return RedisConfiguration.getPortOrElse(this.configuration, this.standaloneConfig::getPort);
    }

    @Deprecated
    public void setPort(int port) {
        this.standaloneConfig.setPort(port);
    }

    public void setPipeliningFlushPolicy(LettuceConnection.PipeliningFlushPolicy pipeliningFlushPolicy) {
        Assert.notNull((Object)pipeliningFlushPolicy, (String)"PipeliningFlushingPolicy must not be null");
        this.pipeliningFlushPolicy = pipeliningFlushPolicy;
    }

    public long getTimeout() {
        return this.getClientTimeout();
    }

    @Deprecated
    public void setTimeout(long timeout) {
        this.getMutableConfiguration().setTimeout(Duration.ofMillis(timeout));
    }

    public boolean isUseSsl() {
        return this.clientConfiguration.isUseSsl();
    }

    @Deprecated
    public void setUseSsl(boolean useSsl) {
        this.getMutableConfiguration().setUseSsl(useSsl);
    }

    @Deprecated(since="3.4")
    public boolean isVerifyPeer() {
        return this.clientConfiguration.isVerifyPeer();
    }

    @Deprecated
    public void setVerifyPeer(boolean verifyPeer) {
        this.getMutableConfiguration().setVerifyPeer(verifyPeer);
    }

    public boolean isStartTls() {
        return this.clientConfiguration.isStartTls();
    }

    @Deprecated
    public void setStartTls(boolean startTls) {
        this.getMutableConfiguration().setStartTls(startTls);
    }

    public boolean getValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public boolean getShareNativeConnection() {
        return this.shareNativeConnection;
    }

    public void setShareNativeConnection(boolean shareNativeConnection) {
        this.shareNativeConnection = shareNativeConnection;
    }

    public boolean getEagerInitialization() {
        return this.eagerInitialization;
    }

    public void setEagerInitialization(boolean eagerInitialization) {
        this.eagerInitialization = eagerInitialization;
    }

    public int getDatabase() {
        return RedisConfiguration.getDatabaseOrElse(this.configuration, this.standaloneConfig::getDatabase);
    }

    @Deprecated
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        if (RedisConfiguration.isDatabaseIndexAware(this.configuration)) {
            ((RedisConfiguration.WithDatabaseIndex)((Object)this.configuration)).setDatabase(index);
            return;
        }
        this.standaloneConfig.setDatabase(index);
    }

    public @Nullable String getClientName() {
        return this.clientConfiguration.getClientName().orElse(null);
    }

    @Deprecated
    public void setClientName(@Nullable String clientName) {
        this.getMutableConfiguration().setClientName(clientName);
    }

    public @Nullable AbstractRedisClient getNativeClient() {
        this.assertStarted();
        return this.client;
    }

    public AbstractRedisClient getRequiredNativeClient() {
        AbstractRedisClient client = this.getNativeClient();
        Assert.state((client != null ? 1 : 0) != 0, (String)"Client not yet initialized; Did you forget to call initialize the bean");
        return client;
    }

    private @Nullable String getRedisUsername() {
        return RedisConfiguration.getUsernameOrElse(this.configuration, this.standaloneConfig::getUsername);
    }

    public @Nullable String getPassword() {
        return this.getRedisPassword().map(String::new).orElse(null);
    }

    private RedisPassword getRedisPassword() {
        return RedisConfiguration.getPasswordOrElse(this.configuration, this.standaloneConfig::getPassword);
    }

    @Deprecated
    public void setPassword(String password) {
        if (RedisConfiguration.isAuthenticationAware(this.configuration)) {
            ((RedisConfiguration.WithPassword)((Object)this.configuration)).setPassword(password);
            return;
        }
        this.standaloneConfig.setPassword(RedisPassword.of(password));
    }

    public long getShutdownTimeout() {
        return this.clientConfiguration.getShutdownTimeout().toMillis();
    }

    @Deprecated
    public void setShutdownTimeout(long shutdownTimeout) {
        this.getMutableConfiguration().setShutdownTimeout(Duration.ofMillis(shutdownTimeout));
    }

    public @Nullable ClientResources getClientResources() {
        return this.clientConfiguration.getClientResources().orElse(null);
    }

    @Deprecated
    public void setClientResources(ClientResources clientResources) {
        this.getMutableConfiguration().setClientResources(clientResources);
    }

    public LettuceClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public RedisStandaloneConfiguration getStandaloneConfiguration() {
        return this.standaloneConfig;
    }

    public @Nullable RedisSocketConfiguration getSocketConfiguration() {
        return this.isDomainSocketAware() ? (RedisSocketConfiguration)this.configuration : null;
    }

    public @Nullable RedisSentinelConfiguration getSentinelConfiguration() {
        return this.isRedisSentinelAware() ? (RedisSentinelConfiguration)this.configuration : null;
    }

    public @Nullable RedisClusterConfiguration getClusterConfiguration() {
        return this.isClusterAware() ? (RedisClusterConfiguration)this.configuration : null;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isEarlyStartup() {
        return this.earlyStartup;
    }

    public void setEarlyStartup(boolean earlyStartup) {
        this.earlyStartup = earlyStartup;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    private boolean isStaticMasterReplicaAware() {
        return RedisConfiguration.isStaticMasterReplicaConfiguration(this.configuration);
    }

    public boolean isRedisSentinelAware() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration);
    }

    private boolean isDomainSocketAware() {
        return RedisConfiguration.isDomainSocketConfiguration(this.configuration);
    }

    public boolean isClusterAware() {
        return RedisConfiguration.isClusterConfiguration(this.configuration);
    }

    public void start() {
        State current = this.state.getAndUpdate(state -> LettuceConnectionFactory.isCreatedOrStopped(state) ? State.STARTING : state);
        if (LettuceConnectionFactory.isCreatedOrStopped(current)) {
            AbstractRedisClient client;
            this.client = client = this.createClient();
            ExceptionTranslatingConnectionProvider connectionProvider = new ExceptionTranslatingConnectionProvider(this.createConnectionProvider(client, LettuceConnection.CODEC));
            this.connectionProvider = connectionProvider;
            this.reactiveConnectionProvider = new ExceptionTranslatingConnectionProvider(this.createConnectionProvider(client, LettuceReactiveRedisConnection.CODEC));
            if (this.isClusterAware()) {
                this.clusterCommandExecutor = this.createClusterCommandExecutor((RedisClusterClient)client, connectionProvider);
            }
            this.state.set(State.STARTED);
            if (this.getEagerInitialization() && this.getShareNativeConnection()) {
                this.initConnection();
            }
        }
    }

    private static boolean isCreatedOrStopped(@Nullable State state) {
        return State.CREATED.equals((Object)state) || State.STOPPED.equals((Object)state);
    }

    private ClusterCommandExecutor createClusterCommandExecutor(RedisClusterClient client, LettuceConnectionProvider connectionProvider) {
        return new ClusterCommandExecutor(new LettuceClusterTopologyProvider(client), new LettuceClusterConnection.LettuceClusterNodeResourceProvider(connectionProvider), EXCEPTION_TRANSLATION, this.executor);
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            this.resetConnection();
            this.dispose(this.clusterCommandExecutor);
            this.clusterCommandExecutor = null;
            this.dispose(this.connectionProvider);
            this.connectionProvider = null;
            this.dispose(this.reactiveConnectionProvider);
            this.reactiveConnectionProvider = null;
            this.dispose(this.client);
            this.client = null;
        }
        this.state.set(State.STOPPED);
    }

    public boolean isRunning() {
        return State.STARTED.equals((Object)this.state.get());
    }

    public void afterPropertiesSet() {
        if (this.isEarlyStartup()) {
            this.start();
        }
    }

    public void destroy() {
        this.stop();
        this.state.set(State.DESTROYED);
    }

    private void dispose(@Nullable ClusterCommandExecutor commandExecutor) {
        if (commandExecutor != null) {
            try {
                commandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
    }

    private void dispose(@Nullable LettuceConnectionProvider connectionProvider) {
        block3: {
            if (connectionProvider instanceof DisposableBean) {
                DisposableBean disposableBean = (DisposableBean)connectionProvider;
                try {
                    disposableBean.destroy();
                }
                catch (Exception ex) {
                    if (!this.log.isWarnEnabled()) break block3;
                    this.log.warn((Object)(String.valueOf(connectionProvider) + " did not shut down gracefully."), (Throwable)ex);
                }
            }
        }
    }

    private void dispose(@Nullable AbstractRedisClient client) {
        block3: {
            if (client != null) {
                try {
                    Duration quietPeriod = this.clientConfiguration.getShutdownQuietPeriod();
                    Duration timeout = this.clientConfiguration.getShutdownTimeout();
                    client.shutdown(quietPeriod.toMillis(), timeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    if (!this.log.isWarnEnabled()) break block3;
                    this.log.warn((Object)(ClassUtils.getShortName(client.getClass()) + " did not shut down gracefully."), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public RedisConnection getConnection() {
        this.assertStarted();
        if (this.isClusterAware()) {
            return this.getClusterConnection();
        }
        LettuceConnection connection = this.doCreateLettuceConnection(this.getSharedConnection(), this.connectionProvider, this.getTimeout(), this.getDatabase());
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return connection;
    }

    @Override
    public RedisClusterConnection getClusterConnection() {
        this.assertStarted();
        if (!this.isClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured");
        }
        RedisClusterClient clusterClient = (RedisClusterClient)this.client;
        StatefulRedisClusterConnection<byte[], byte[]> sharedConnection = this.getSharedClusterConnection();
        LettuceClusterTopologyProvider topologyProvider = new LettuceClusterTopologyProvider(clusterClient);
        return this.doCreateLettuceClusterConnection(sharedConnection, this.connectionProvider, topologyProvider, this.getRequiredClusterCommandExecutor(), this.clientConfiguration.getCommandTimeout());
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        this.assertStarted();
        return new LettuceSentinelConnection(this.connectionProvider);
    }

    protected LettuceConnection doCreateLettuceConnection(@Nullable StatefulRedisConnection<byte[], byte[]> sharedConnection, LettuceConnectionProvider connectionProvider, long timeout, int database) {
        LettuceConnection connection = new LettuceConnection(sharedConnection, connectionProvider, timeout, database);
        connection.setPipeliningFlushPolicy(this.pipeliningFlushPolicy);
        return connection;
    }

    protected LettuceClusterConnection doCreateLettuceClusterConnection(@Nullable StatefulRedisClusterConnection<byte[], byte[]> sharedConnection, LettuceConnectionProvider connectionProvider, ClusterTopologyProvider topologyProvider, ClusterCommandExecutor clusterCommandExecutor, Duration commandTimeout) {
        LettuceClusterConnection connection = new LettuceClusterConnection(sharedConnection, connectionProvider, topologyProvider, clusterCommandExecutor, commandTimeout);
        connection.setPipeliningFlushPolicy(this.pipeliningFlushPolicy);
        return connection;
    }

    @Override
    public LettuceReactiveRedisConnection getReactiveConnection() {
        this.assertStarted();
        if (this.isClusterAware()) {
            return this.getReactiveClusterConnection();
        }
        return this.getShareNativeConnection() ? new LettuceReactiveRedisConnection(this.getSharedReactiveConnection(), this.reactiveConnectionProvider) : new LettuceReactiveRedisConnection(this.reactiveConnectionProvider);
    }

    @Override
    public LettuceReactiveRedisClusterConnection getReactiveClusterConnection() {
        this.assertStarted();
        if (!this.isClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured");
        }
        RedisClusterClient client = (RedisClusterClient)this.client;
        return this.getShareNativeConnection() ? new LettuceReactiveRedisClusterConnection(this.getSharedReactiveConnection(), this.reactiveConnectionProvider, client) : new LettuceReactiveRedisClusterConnection(this.reactiveConnectionProvider, client);
    }

    public void initConnection() {
        this.resetConnection();
        if (this.isClusterAware()) {
            this.getSharedClusterConnection();
        } else {
            this.getSharedConnection();
        }
        this.getSharedReactiveConnection();
    }

    public void resetConnection() {
        this.doInLock(() -> {
            if (this.connection != null) {
                this.connection.resetConnection();
            }
            if (this.reactiveConnection != null) {
                this.reactiveConnection.resetConnection();
            }
            this.connection = null;
            this.reactiveConnection = null;
        });
    }

    public void validateConnection() {
        this.assertStarted();
        this.getOrCreateSharedConnection().validateConnection();
        this.getOrCreateSharedReactiveConnection().validateConnection();
    }

    private SharedConnection<byte[]> getOrCreateSharedConnection() {
        return this.doInLock(() -> {
            if (this.connection == null) {
                this.connection = new SharedConnection(this.connectionProvider);
            }
            return this.connection;
        });
    }

    private SharedConnection<ByteBuffer> getOrCreateSharedReactiveConnection() {
        return this.doInLock(() -> {
            if (this.reactiveConnection == null) {
                this.reactiveConnection = new SharedConnection(this.reactiveConnectionProvider);
            }
            return this.reactiveConnection;
        });
    }

    public @Nullable DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    protected @Nullable StatefulRedisConnection<byte[], byte[]> getSharedConnection() {
        return this.shareNativeConnection && !this.isClusterAware() ? (StatefulRedisConnection)this.getOrCreateSharedConnection().getConnection() : null;
    }

    protected @Nullable StatefulRedisClusterConnection<byte[], byte[]> getSharedClusterConnection() {
        return this.shareNativeConnection && this.isClusterAware() ? (StatefulRedisClusterConnection)this.getOrCreateSharedConnection().getConnection() : null;
    }

    protected @Nullable StatefulConnection<ByteBuffer, ByteBuffer> getSharedReactiveConnection() {
        return this.shareNativeConnection ? this.getOrCreateSharedReactiveConnection().getConnection() : null;
    }

    LettuceConnectionProvider createConnectionProvider(AbstractRedisClient client, RedisCodec<?, ?> codec) {
        LettuceConnectionProvider connectionProvider = this.doCreateConnectionProvider(client, codec);
        LettuceClientConfiguration lettuceClientConfiguration = this.clientConfiguration;
        if (lettuceClientConfiguration instanceof LettucePoolingClientConfiguration) {
            LettucePoolingClientConfiguration poolingClientConfiguration = (LettucePoolingClientConfiguration)lettuceClientConfiguration;
            return new LettucePoolingConnectionProvider(connectionProvider, poolingClientConfiguration);
        }
        return connectionProvider;
    }

    protected LettuceConnectionProvider doCreateConnectionProvider(AbstractRedisClient client, RedisCodec<?, ?> codec) {
        return this.isStaticMasterReplicaAware() ? this.createStaticMasterReplicaConnectionProvider((RedisClient)client, codec) : (this.isClusterAware() ? this.createClusterConnectionProvider((RedisClusterClient)client, codec) : this.createStandaloneConnectionProvider((RedisClient)client, codec));
    }

    private StaticMasterReplicaConnectionProvider createStaticMasterReplicaConnectionProvider(RedisClient client, RedisCodec<?, ?> codec) {
        List<RedisURI> nodes = ((RedisStaticMasterReplicaConfiguration)this.configuration).getNodes().stream().map(it -> this.createRedisURIAndApplySettings(it.getHostName(), it.getPort())).peek(it -> it.setDatabase(this.getDatabase())).collect(Collectors.toList());
        return new StaticMasterReplicaConnectionProvider(client, codec, nodes, this.getClientConfiguration().getReadFrom().orElse(null));
    }

    private ClusterConnectionProvider createClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec) {
        return new ClusterConnectionProvider(client, codec, this.getClientConfiguration().getReadFrom().orElse(null));
    }

    private StandaloneConnectionProvider createStandaloneConnectionProvider(RedisClient client, RedisCodec<?, ?> codec) {
        return new StandaloneConnectionProvider(client, codec, this.getClientConfiguration().getReadFrom().orElse(null));
    }

    protected AbstractRedisClient createClient() {
        return this.isStaticMasterReplicaAware() ? this.createStaticMasterReplicaClient() : (this.isRedisSentinelAware() ? this.createSentinelClient() : (this.isClusterAware() ? this.createClusterClient() : this.createBasicClient()));
    }

    private RedisClient createStaticMasterReplicaClient() {
        RedisClient redisClient = this.clientConfiguration.getClientResources().map(RedisClient::create).orElseGet(RedisClient::create);
        this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
        return redisClient;
    }

    private RedisClient createSentinelClient() {
        RedisURI redisURI = this.getSentinelRedisURI();
        RedisClient redisClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)redisURI)).orElseGet(() -> RedisClient.create((RedisURI)redisURI));
        this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
        return redisClient;
    }

    private RedisURI getSentinelRedisURI() {
        RedisSentinelConfiguration sentinelConfiguration = (RedisSentinelConfiguration)this.configuration;
        RedisURI redisUri = LettuceConverters.sentinelConfigurationToRedisURI(sentinelConfiguration);
        LettuceConnectionFactory.applyToAll(redisUri, it -> {
            this.clientConfiguration.getClientName().ifPresent(arg_0 -> ((RedisURI)it).setClientName(arg_0));
            it.setSsl(this.clientConfiguration.isUseSsl());
            it.setVerifyPeer(this.clientConfiguration.getVerifyMode());
            it.setStartTls(this.clientConfiguration.isStartTls());
            it.setTimeout(this.clientConfiguration.getCommandTimeout());
        });
        redisUri.setDatabase(this.getDatabase());
        this.clientConfiguration.getRedisCredentialsProviderFactory().ifPresent(factory -> {
            redisUri.setCredentialsProvider(factory.createCredentialsProvider(this.configuration));
            RedisCredentialsProvider sentinelCredentials = factory.createSentinelCredentialsProvider((RedisSentinelConfiguration)this.configuration);
            redisUri.getSentinels().forEach(it -> it.setCredentialsProvider(sentinelCredentials));
        });
        return redisUri;
    }

    private RedisClusterClient createClusterClient() {
        ArrayList initialUris = new ArrayList();
        RedisConfiguration.ClusterConfiguration clusterConfiguration = (RedisConfiguration.ClusterConfiguration)((Object)this.configuration);
        clusterConfiguration.getClusterNodes().stream().map(node -> this.createRedisURIAndApplySettings(node.getRequiredHost(), node.getRequiredPort())).forEach(initialUris::add);
        RedisClusterClient clusterClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClusterClient.create((ClientResources)clientResources, (Iterable)initialUris)).orElseGet(() -> RedisClusterClient.create((Iterable)initialUris));
        clusterClient.setOptions(this.getClusterClientOptions(clusterConfiguration));
        return clusterClient;
    }

    private ClusterClientOptions getClusterClientOptions(RedisConfiguration.ClusterConfiguration clusterConfiguration) {
        Optional<ClientOptions> clientOptions = this.clientConfiguration.getClientOptions();
        Optional<ClusterClientOptions> clusterClientOptions = clientOptions.filter(ClusterClientOptions.class::isInstance).map(ClusterClientOptions.class::cast);
        ClusterClientOptions resolvedClusterClientOptions = clusterClientOptions.orElseGet(() -> clientOptions.map(it -> ClusterClientOptions.builder((ClientOptions)it).build()).orElseGet(ClusterClientOptions::create));
        if (clusterConfiguration.getMaxRedirects() != null) {
            return resolvedClusterClientOptions.mutate().maxRedirects(clusterConfiguration.getMaxRedirects().intValue()).build();
        }
        return resolvedClusterClientOptions;
    }

    private RedisClient createBasicClient() {
        RedisURI uri = this.isDomainSocketAware() ? this.createRedisSocketURIAndApplySettings(this.getSocketConfiguration().getSocket()) : this.createRedisURIAndApplySettings(this.getHostName(), this.getPort());
        RedisClient redisClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)uri)).orElseGet(() -> RedisClient.create((RedisURI)uri));
        this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
        return redisClient;
    }

    private void assertStarted() {
        State current = this.state.get();
        if (State.STARTED.equals((Object)current)) {
            return;
        }
        switch (current.ordinal()) {
            case 0: 
            case 4: {
                throw new IllegalStateException("LettuceConnectionFactory has been %s. Use start() to initialize it".formatted(new Object[]{current}));
            }
            case 5: {
                throw new IllegalStateException("LettuceConnectionFactory was destroyed and cannot be used anymore");
            }
        }
        throw new IllegalStateException("LettuceConnectionFactory is %s".formatted(new Object[]{current}));
    }

    private static void applyToAll(RedisURI source, Consumer<RedisURI> action) {
        action.accept(source);
        source.getSentinels().forEach(action);
    }

    private RedisURI createRedisURIAndApplySettings(String host, int port) {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)host, (int)port);
        this.applyAuthentication(builder);
        this.clientConfiguration.getClientName().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withClientName(arg_0));
        builder.withDatabase(this.getDatabase());
        builder.withSsl(this.clientConfiguration.isUseSsl());
        builder.withVerifyPeer(this.clientConfiguration.getVerifyMode());
        builder.withStartTls(this.clientConfiguration.isStartTls());
        builder.withTimeout(this.clientConfiguration.getCommandTimeout());
        return builder.build();
    }

    private RedisURI createRedisSocketURIAndApplySettings(String socketPath) {
        return this.applyAuthentication(RedisURI.Builder.socket((String)socketPath)).withTimeout(this.clientConfiguration.getCommandTimeout()).withDatabase(this.getDatabase()).build();
    }

    private RedisURI.Builder applyAuthentication(RedisURI.Builder builder) {
        String username = this.getRedisUsername();
        if (StringUtils.hasText((String)username)) {
            builder.withAuthentication(username, (CharSequence)new String(this.getRedisPassword().toOptional().orElse(new char[0])));
        } else {
            this.getRedisPassword().toOptional().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withPassword(arg_0));
        }
        this.clientConfiguration.getRedisCredentialsProviderFactory().ifPresent(factory -> builder.withAuthentication(factory.createCredentialsProvider(this.configuration)));
        return builder;
    }

    private MutableLettuceClientConfiguration getMutableConfiguration() {
        Assert.state((boolean)(this.clientConfiguration instanceof MutableLettuceClientConfiguration), () -> "Client configuration must be instance of MutableLettuceClientConfiguration but is %s".formatted(ClassUtils.getShortName(this.clientConfiguration.getClass())));
        return (MutableLettuceClientConfiguration)this.clientConfiguration;
    }

    private long getClientTimeout() {
        return this.clientConfiguration.getCommandTimeout().toMillis();
    }

    private void doInLock(Runnable runnable) {
        this.doInLock(() -> {
            runnable.run();
            return null;
        });
    }

    private <T> T doInLock(Supplier<T> supplier) {
        this.lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    static class MutableLettuceClientConfiguration
    implements LettuceClientConfiguration {
        private boolean useSsl;
        private SslVerifyMode verifyMode = SslVerifyMode.FULL;
        private boolean startTls;
        private @Nullable ClientResources clientResources;
        private Duration timeout = Duration.ofSeconds(60L);
        private Duration shutdownTimeout = Duration.ofMillis(100L);
        private @Nullable String clientName;

        MutableLettuceClientConfiguration() {
        }

        @Override
        public boolean isUseSsl() {
            return this.useSsl;
        }

        void setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
        }

        @Override
        public boolean isVerifyPeer() {
            return this.verifyMode != SslVerifyMode.NONE;
        }

        @Override
        public SslVerifyMode getVerifyMode() {
            return this.verifyMode;
        }

        void setVerifyPeer(boolean verifyPeer) {
            this.verifyMode = verifyPeer ? SslVerifyMode.FULL : SslVerifyMode.NONE;
        }

        @Override
        public boolean isStartTls() {
            return this.startTls;
        }

        void setStartTls(boolean startTls) {
            this.startTls = startTls;
        }

        @Override
        public Optional<ClientResources> getClientResources() {
            return Optional.ofNullable(this.clientResources);
        }

        void setClientResources(ClientResources clientResources) {
            this.clientResources = clientResources;
        }

        @Override
        public Optional<ClientOptions> getClientOptions() {
            return Optional.empty();
        }

        @Override
        public Optional<ReadFrom> getReadFrom() {
            return Optional.empty();
        }

        @Override
        public Optional<RedisCredentialsProviderFactory> getRedisCredentialsProviderFactory() {
            return Optional.empty();
        }

        @Override
        public Optional<String> getClientName() {
            return Optional.ofNullable(this.clientName);
        }

        void setClientName(@Nullable String clientName) {
            this.clientName = clientName;
        }

        @Override
        public Duration getCommandTimeout() {
            return this.timeout;
        }

        void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Override
        public Duration getShutdownTimeout() {
            return this.shutdownTimeout;
        }

        void setShutdownTimeout(Duration shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
        }

        @Override
        public Duration getShutdownQuietPeriod() {
            return this.shutdownTimeout;
        }
    }

    static enum State {
        CREATED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        DESTROYED;

    }

    private static class ExceptionTranslatingConnectionProvider
    implements LettuceConnectionProvider,
    LettuceConnectionProvider.TargetAware,
    DisposableBean {
        private final LettuceConnectionProvider delegate;

        public ExceptionTranslatingConnectionProvider(LettuceConnectionProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
            try {
                return this.delegate.getConnection(connectionType);
            }
            catch (RuntimeException ex) {
                throw this.translateException(ex);
            }
        }

        @Override
        public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType, RedisURI redisURI) {
            try {
                return ((LettuceConnectionProvider.TargetAware)((Object)this.delegate)).getConnection(connectionType, redisURI);
            }
            catch (RuntimeException ex) {
                throw this.translateException(ex);
            }
        }

        @Override
        public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
            CompletableFuture future = new CompletableFuture();
            this.delegate.getConnectionAsync(connectionType).whenComplete((t, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally(this.translateException((Throwable)throwable));
                } else {
                    future.complete(t);
                }
            });
            return future;
        }

        @Override
        public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType, RedisURI redisURI) {
            CompletableFuture future = new CompletableFuture();
            ((LettuceConnectionProvider.TargetAware)((Object)this.delegate)).getConnectionAsync(connectionType, redisURI).whenComplete((t, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally(this.translateException((Throwable)throwable));
                } else {
                    future.complete(t);
                }
            });
            return future;
        }

        @Override
        public void release(StatefulConnection<?, ?> connection) {
            this.delegate.release(connection);
        }

        @Override
        public CompletableFuture<Void> releaseAsync(StatefulConnection<?, ?> connection) {
            return this.delegate.releaseAsync(connection);
        }

        public void destroy() throws Exception {
            LettuceConnectionProvider lettuceConnectionProvider = this.delegate;
            if (lettuceConnectionProvider instanceof DisposableBean) {
                DisposableBean disposableBean = (DisposableBean)lettuceConnectionProvider;
                disposableBean.destroy();
            }
        }

        private RuntimeException translateException(Throwable cause) {
            RedisConnectionFailureException connectionFailure;
            return cause instanceof RedisConnectionFailureException ? (connectionFailure = (RedisConnectionFailureException)((Object)cause)) : new RedisConnectionFailureException("Unable to connect to Redis", cause);
        }
    }

    class SharedConnection<E> {
        private final LettuceConnectionProvider connectionProvider;
        private @Nullable StatefulConnection<E, E> connection;

        SharedConnection(LettuceConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        @Nullable StatefulConnection<E, E> getConnection() {
            return LettuceConnectionFactory.this.doInLock(() -> {
                if (this.connection == null) {
                    this.connection = this.getNativeConnection();
                }
                if (LettuceConnectionFactory.this.getValidateConnection()) {
                    this.validateConnection();
                }
                return this.connection;
            });
        }

        private StatefulConnection<E, E> getNativeConnection() {
            return this.connectionProvider.getConnection(StatefulConnection.class);
        }

        private boolean isOpen(@Nullable StatefulConnection<?, ?> connection) {
            return connection != null && connection.isOpen();
        }

        void validateConnection() {
            LettuceConnectionFactory.this.doInLock(() -> {
                StatefulConnection<E, E> connection = this.connection;
                boolean valid = false;
                if (this.isOpen(connection)) {
                    try {
                        if (connection instanceof StatefulRedisConnection) {
                            StatefulRedisConnection statefulConnection = (StatefulRedisConnection)connection;
                            statefulConnection.sync().ping();
                        }
                        if (connection instanceof StatefulRedisClusterConnection) {
                            StatefulRedisClusterConnection statefulClusterConnection = (StatefulRedisClusterConnection)connection;
                            statefulClusterConnection.sync().ping();
                        }
                        valid = true;
                    }
                    catch (Exception ex) {
                        LettuceConnectionFactory.this.log.debug((Object)"Validation failed", (Throwable)ex);
                    }
                }
                if (!valid) {
                    LettuceConnectionFactory.this.log.info((Object)"Validation of shared connection failed; Creating a new connection.");
                    this.resetConnection();
                    this.connection = this.getNativeConnection();
                }
            });
        }

        void resetConnection() {
            LettuceConnectionFactory.this.doInLock(() -> {
                StatefulConnection<E, E> connection = this.connection;
                if (connection != null) {
                    this.connectionProvider.release(connection);
                }
                this.connection = null;
            });
        }
    }
}

