/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Segment;

public class TupleExpression
extends AbstractSegment
implements Expression {
    private final Collection<? extends Expression> expressions;

    private static Segment[] children(Collection<? extends Expression> expressions) {
        return expressions.toArray(new Segment[0]);
    }

    TupleExpression(Collection<? extends Expression> expressions) {
        super(TupleExpression.children(expressions));
        this.expressions = expressions;
    }

    public static TupleExpression create(Expression ... expressions) {
        return new TupleExpression(List.of(expressions));
    }

    public static TupleExpression create(Collection<? extends Expression> expressions) {
        return new TupleExpression(expressions);
    }

    @Override
    public String toString() {
        return "(" + this.expressions.stream().map(Segment::toString).collect(Collectors.joining(", ")) + ")";
    }
}

