/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AnnotatedHandlerBeanPostProcessor;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.core.invoke.DefaultRepositoryInvokerFactory;
import org.springframework.data.rest.core.invoke.RepositoryInvokerFactory;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.support.DomainObjectMerger;
import org.springframework.data.rest.core.support.RepositoryRelProvider;
import org.springframework.data.rest.core.util.UUIDConverter;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.PersistentEntityResourceHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.ServerHttpRequestMethodArgumentResolver;
import org.springframework.data.rest.webmvc.convert.UriListHttpMessageConverter;
import org.springframework.data.rest.webmvc.json.Jackson2DatatypeHelper;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson2Module;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.support.BackendIdHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.HttpMethodHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.rest.webmvc.support.ValidationExceptionHandler;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ComponentScan(basePackageClasses={RepositoryRestController.class}, includeFilters={@ComponentScan.Filter(value={RepositoryRestController.class})}, useDefaultFilters=false)
@ImportResource(value={"classpath*:META-INF/spring-data-rest/**/*.xml"})
public class RepositoryRestMvcConfiguration
extends HateoasAwareSpringDataWebConfiguration {
    private static final boolean IS_JAVAX_VALIDATION_AVAILABLE = ClassUtils.isPresent((String)"javax.validation.ConstraintViolationException", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());
    private static final boolean IS_JPA_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.EntityManager", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());
    @Autowired
    ListableBeanFactory beanFactory;
    @Autowired(required=false)
    List<ResourceProcessor<?>> resourceProcessors = Collections.emptyList();
    @Autowired(required=false)
    RelProvider relProvider;
    @Autowired(required=false)
    CurieProvider curieProvider;

    @Bean
    public Repositories repositories() {
        return new Repositories(this.beanFactory);
    }

    @Bean
    public RepositoryRelProvider repositoryRelProvider(ObjectFactory<ResourceMappings> resourceMappings) {
        return new RepositoryRelProvider(resourceMappings);
    }

    @Bean
    @Qualifier
    public DefaultFormattingConversionService defaultConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        conversionService.addConverter((GenericConverter)UUIDConverter.INSTANCE);
        this.configureConversionService((ConfigurableConversionService)conversionService);
        return conversionService;
    }

    @Bean
    public DomainClassConverter<?> domainClassConverter() {
        return new DomainClassConverter((ConversionService)this.defaultConversionService());
    }

    @Bean
    public UriToEntityConverter uriToEntityConverter() {
        return new UriToEntityConverter(this.repositories(), this.domainClassConverter());
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener(ObjectFactory<Repositories> repositories) {
        ValidatingRepositoryEventListener listener = new ValidatingRepositoryEventListener(repositories);
        this.configureValidatingRepositoryEventListener(listener);
        return listener;
    }

    @Bean
    @Lazy
    public ValidationExceptionHandler validationExceptionHandler() {
        if (IS_JAVAX_VALIDATION_AVAILABLE) {
            return new ValidationExceptionHandler();
        }
        return null;
    }

    @Bean
    public JpaHelper jpaHelper() {
        if (IS_JPA_AVAILABLE) {
            return new JpaHelper();
        }
        return null;
    }

    @Bean
    public RepositoryRestConfiguration config() {
        RepositoryRestConfiguration config = new RepositoryRestConfiguration();
        this.configureRepositoryRestConfiguration(config);
        return config;
    }

    @Bean
    public AnnotatedHandlerBeanPostProcessor annotatedHandlerBeanPostProcessor() {
        return new AnnotatedHandlerBeanPostProcessor();
    }

    @Bean
    public DomainObjectMerger domainObjectMerger() throws Exception {
        return new DomainObjectMerger(this.repositories(), (ConversionService)this.defaultConversionService());
    }

    @Bean
    public ServerHttpRequestMethodArgumentResolver serverHttpRequestMethodArgumentResolver() {
        return new ServerHttpRequestMethodArgumentResolver();
    }

    @Bean
    public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver() {
        return new RootResourceInformationHandlerMethodArgumentResolver(this.repositories(), this.repositoryInvokerFactory(), this.resourceMetadataHandlerMethodArgumentResolver());
    }

    @Bean
    public ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver() {
        return new ResourceMetadataHandlerMethodArgumentResolver(this.repositories(), this.resourceMappings());
    }

    @Bean
    public BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver() {
        return new BackendIdHandlerMethodArgumentResolver(this.resourceMetadataHandlerMethodArgumentResolver());
    }

    @Bean
    public EntityLinks entityLinks() {
        return new RepositoryEntityLinks(this.repositories(), this.resourceMappings(), this.config(), this.pageableResolver());
    }

    @Bean
    public PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver() {
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        return new PersistentEntityResourceHandlerMethodArgumentResolver(messageConverters, this.repoRequestArgumentResolver());
    }

    @Bean
    public PersistentEntityToJsonSchemaConverter jsonSchemaConverter() {
        return new PersistentEntityToJsonSchemaConverter(this.repositories(), this.resourceMappings(), this.resourceDescriptionMessageSourceAccessor());
    }

    @Bean
    public MessageSourceAccessor resourceDescriptionMessageSourceAccessor() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:rest-messages");
        messageSource.setUseCodeAsDefaultMessage(true);
        return new MessageSourceAccessor((MessageSource)messageSource);
    }

    @Bean
    public ObjectMapper objectMapper() {
        return this.basicObjectMapper();
    }

    @Bean
    public MappingJackson2HttpMessageConverter jacksonHttpMessageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.addAll(Arrays.asList(MediaType.valueOf((String)"application/schema+json"), MediaType.valueOf((String)"application/x-spring-data-verbose+json"), MediaType.valueOf((String)"application/x-spring-data-compact+json")));
        if (!this.config().getDefaultMediaType().equals((Object)MediaTypes.HAL_JSON)) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter();
        jacksonConverter.setObjectMapper(this.objectMapper());
        jacksonConverter.setSupportedMediaTypes(mediaTypes);
        return jacksonConverter;
    }

    @Bean
    public MappingJackson2HttpMessageConverter halJacksonHttpMessageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaTypes.HAL_JSON);
        if (this.config().getDefaultMediaType().equals((Object)MediaTypes.HAL_JSON)) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(this.halObjectMapper());
        converter.setSupportedMediaTypes(mediaTypes);
        return converter;
    }

    @Bean
    public ObjectMapper halObjectMapper() {
        Jackson2HalModule.HalHandlerInstantiator instantiator = new Jackson2HalModule.HalHandlerInstantiator(this.getDefaultedRelProvider(), this.curieProvider);
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)instantiator);
        return mapper;
    }

    @Bean
    public UriListHttpMessageConverter uriListHttpMessageConverter() {
        return new UriListHttpMessageConverter();
    }

    @Bean
    public PersistentEntityResourceAssembler<Object> persistentEntityResourceAssembler() {
        return new PersistentEntityResourceAssembler<Object>(this.repositories(), this.entityLinks());
    }

    @Bean
    public RequestMappingHandlerAdapter repositoryExporterHandlerAdapter() {
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        RepositoryRestHandlerAdapter handlerAdapter = new RepositoryRestHandlerAdapter(this.defaultMethodArgumentResolvers(), this.resourceProcessors);
        handlerAdapter.setMessageConverters(messageConverters);
        return handlerAdapter;
    }

    @Bean
    public RequestMappingHandlerMapping repositoryExporterHandlerMapping() {
        RepositoryRestHandlerMapping mapping = new RepositoryRestHandlerMapping(this.resourceMappings(), this.config());
        mapping.setJpaHelper(this.jpaHelper());
        return mapping;
    }

    @Bean
    public ResourceMappings resourceMappings() {
        Repositories repositories = this.repositories();
        RepositoryRestConfiguration config = this.config();
        return new ResourceMappings(config, repositories);
    }

    @Bean
    public Module persistentEntityJackson2Module() {
        return new PersistentEntityJackson2Module(this.resourceMappings(), this.repositories(), this.config(), this.uriToEntityConverter());
    }

    @Bean
    public ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver() {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers());
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        er.setMessageConverters(messageConverters);
        this.configureExceptionHandlerExceptionResolver(er);
        return er;
    }

    @Bean
    public RepositoryInvokerFactory repositoryInvokerFactory() {
        return new DefaultRepositoryInvokerFactory(this.repositories(), (ConversionService)this.defaultConversionService());
    }

    @Bean
    public List<HttpMessageConverter<?>> defaultMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        if (this.config().getDefaultMediaType().equals((Object)MediaTypes.HAL_JSON)) {
            messageConverters.add((HttpMessageConverter<?>)this.halJacksonHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)this.jacksonHttpMessageConverter());
        } else {
            messageConverters.add((HttpMessageConverter<?>)this.jacksonHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)this.halJacksonHttpMessageConverter());
        }
        messageConverters.add(this.uriListHttpMessageConverter());
        return messageConverters;
    }

    @Bean
    public HateoasPageableHandlerMethodArgumentResolver pageableResolver() {
        HateoasPageableHandlerMethodArgumentResolver resolver = super.pageableResolver();
        resolver.setPageParameterName(this.config().getPageParamName());
        resolver.setSizeParameterName(this.config().getLimitParamName());
        resolver.setFallbackPageable((Pageable)new PageRequest(0, this.config().getDefaultPageSize()));
        resolver.setMaxPageSize(this.config().getMaxPageSize());
        return resolver;
    }

    @Bean
    public HateoasSortHandlerMethodArgumentResolver sortResolver() {
        HateoasSortHandlerMethodArgumentResolver resolver = super.sortResolver();
        resolver.setSortParameter(this.config().getSortParamName());
        return resolver;
    }

    private List<HandlerMethodArgumentResolver> defaultMethodArgumentResolvers() {
        return Arrays.asList(new HandlerMethodArgumentResolver[]{this.pageableResolver(), this.sortResolver(), this.serverHttpRequestMethodArgumentResolver(), this.repoRequestArgumentResolver(), this.persistentEntityArgumentResolver(), this.resourceMetadataHandlerMethodArgumentResolver(), HttpMethodHandlerMethodArgumentResolver.INSTANCE, this.backendIdHandlerMethodArgumentResolver()});
    }

    private ObjectMapper basicObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.registerModule(this.persistentEntityJackson2Module());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Jackson2DatatypeHelper.configureObjectMapper(objectMapper);
        this.configureJacksonObjectMapper(objectMapper);
        return objectMapper;
    }

    private RelProvider getDefaultedRelProvider() {
        return this.relProvider != null ? this.relProvider : new EvoInflectorRelProvider();
    }

    protected void configureRepositoryRestConfiguration(RepositoryRestConfiguration config) {
    }

    protected void configureConversionService(ConfigurableConversionService conversionService) {
    }

    protected void configureValidatingRepositoryEventListener(ValidatingRepositoryEventListener validatingListener) {
    }

    protected void configureExceptionHandlerExceptionResolver(ExceptionHandlerExceptionResolver exceptionResolver) {
    }

    protected void configureHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
    }

    protected void configureJacksonObjectMapper(ObjectMapper objectMapper) {
    }

    @Configuration
    @EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
    static class HypermediaConfigurationDelegate {
        HypermediaConfigurationDelegate() {
        }
    }
}

