/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.net.URI;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.RepositoryController;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryLinkBuilder
extends LinkBuilderSupport<RepositoryLinkBuilder> {
    private final ResourceMetadata metadata;

    public RepositoryLinkBuilder(ResourceMetadata metadata, URI baseUri) {
        this(metadata, RepositoryLinkBuilder.prepareBuilder(baseUri, metadata));
    }

    private RepositoryLinkBuilder(ResourceMetadata metadata, UriComponentsBuilder builder) {
        super(builder);
        this.metadata = metadata;
    }

    private static UriComponentsBuilder prepareBuilder(URI baseUri, ResourceMetadata metadata) {
        UriComponentsBuilder builder = baseUri != null ? UriComponentsBuilder.fromUri((URI)baseUri) : ControllerLinkBuilder.linkTo(RepositoryController.class).toUriComponentsBuilder();
        return builder.path(metadata.getPath().toString());
    }

    public RepositoryLinkBuilder slash(Object object) {
        if (object instanceof PersistentProperty) {
            return this.slash((PersistentProperty)object);
        }
        return (RepositoryLinkBuilder)super.slash(object);
    }

    public RepositoryLinkBuilder slash(PersistentProperty<?> property) {
        String propName = property.getName();
        if (this.metadata.isManagedResource(property)) {
            return this.slash(this.metadata.getMappingFor(property).getPath());
        }
        return this.slash(propName);
    }

    public Link withResourceRel() {
        return this.withRel(this.metadata.getRel());
    }

    protected RepositoryLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new RepositoryLinkBuilder(this.metadata, builder);
    }

    protected RepositoryLinkBuilder getThis() {
        return this;
    }
}

