/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.listener;

import java.nio.ByteBuffer;
import kafka.serializer.Decoder;
import kafka.serializer.Encoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.kafka.util.LoggingUtils;

public class LongEncoderDecoder
implements Encoder<Long>,
Decoder<Long> {
    private Log log = LogFactory.getLog(LongEncoderDecoder.class);

    public Long fromBytes(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        try {
            return ByteBuffer.wrap(bytes).getLong(0);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot decode value: " + LoggingUtils.asCommaSeparatedHexDump(bytes)));
            }
            return null;
        }
    }

    public byte[] toBytes(Long value) {
        if (value == null) {
            return null;
        }
        return ByteBuffer.allocate(8).putLong(value).array();
    }
}

