/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.kafka.support.ProducerConfiguration;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.Message;

public class KafkaProducerContext<K, V>
implements SmartLifecycle,
NamedComponent,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(KafkaProducerContext.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private volatile Map<String, ProducerConfiguration<K, V>> producerConfigurations;
    private volatile ProducerConfiguration<K, V> theProducerConfiguration;
    private String beanName = "not_specified";
    private int phase = 0;
    private boolean autoStartup = true;

    public ProducerConfiguration<K, V> getTopicConfiguration(String topic) {
        if (this.theProducerConfiguration != null && topic.matches(this.theProducerConfiguration.getProducerMetadata().getTopic())) {
            return this.theProducerConfiguration;
        }
        Collection<ProducerConfiguration<K, V>> topics = this.producerConfigurations.values();
        for (ProducerConfiguration<K, V> producerConfiguration : topics) {
            if (!topic.matches(producerConfiguration.getProducerMetadata().getTopic())) continue;
            return producerConfiguration;
        }
        return null;
    }

    public Map<String, ProducerConfiguration<K, V>> getProducerConfigurations() {
        return this.producerConfigurations;
    }

    public void setProducerConfigurations(Map<String, ProducerConfiguration<K, V>> producerConfigurations) {
        this.producerConfigurations = producerConfigurations;
        if (this.producerConfigurations.size() == 1) {
            this.theProducerConfiguration = this.producerConfigurations.values().iterator().next();
        }
    }

    public String getComponentType() {
        return "kafka:producer-context";
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public String getComponentName() {
        return this.beanName;
    }

    protected void doStart() {
    }

    protected void doStop() {
        if (this.producerConfigurations != null) {
            for (ProducerConfiguration<K, V> producerConfiguration : this.producerConfigurations.values()) {
                producerConfiguration.stop();
            }
        }
    }

    public final void start() {
        if (this.running.compareAndSet(false, true)) {
            this.doStart();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getComponentType() + ":" + this.getComponentName() + " is already running"));
        }
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.doStop();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getComponentType() + ":" + this.getComponentName() + " is not running"));
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void send(String topic, Object messageKey, Message<?> message) throws Exception {
        ProducerConfiguration<K, V> producerConfiguration;
        if (!this.running.get()) {
            this.start();
        }
        if ((producerConfiguration = this.getTopicConfiguration(topic)) != null) {
            producerConfiguration.send(topic, messageKey, message);
        } else if (this.theProducerConfiguration != null) {
            this.theProducerConfiguration.send(topic, messageKey, message);
        } else {
            throw new IllegalStateException("Could not send messages as there are multiple producer configurations with no topic information found from the message header.");
        }
    }
}

