/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.serializer.DefaultEncoder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.integration.kafka.support.ProducerMetadata;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ProducerConfiguration<K, V> {
    private final Producer<K, V> producer;
    private final ProducerMetadata<K, V> producerMetadata;

    public ProducerConfiguration(ProducerMetadata<K, V> producerMetadata, Producer<K, V> producer) {
        Assert.notNull(producerMetadata);
        Assert.notNull(producer);
        this.producerMetadata = producerMetadata;
        this.producer = producer;
    }

    public ProducerMetadata<K, V> getProducerMetadata() {
        return this.producerMetadata;
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public void send(String topic, Object messageKey, Message<?> message) throws Exception {
        V v = this.getPayload(message);
        if (!StringUtils.hasText((String)topic)) {
            topic = this.producerMetadata.getTopic();
        }
        this.producer.send(new KeyedMessage(topic, messageKey != null ? this.getKey(messageKey) : null, v));
    }

    private V getPayload(Message<?> message) throws Exception {
        if (this.producerMetadata.getValueEncoder() instanceof DefaultEncoder) {
            return (V)ProducerConfiguration.getByteStream(message.getPayload());
        }
        if (this.producerMetadata.getValueClassType().isAssignableFrom(message.getPayload().getClass())) {
            return this.producerMetadata.getValueClassType().cast(message.getPayload());
        }
        throw new MessageHandlingException(message, "Message payload type is not matching with what is configured");
    }

    private K getKey(Object messageKey) throws Exception {
        if (this.producerMetadata.getKeyEncoder() instanceof DefaultEncoder) {
            return (K)ProducerConfiguration.getByteStream(messageKey);
        }
        return (K)messageKey;
    }

    private static boolean isRawByteArray(Object obj) {
        return obj instanceof byte[];
    }

    private static byte[] getByteStream(Object obj) throws IOException {
        if (ProducerConfiguration.isRawByteArray(obj)) {
            return (byte[])obj;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(obj);
        return out.toByteArray();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return "ProducerConfiguration [producerMetadata=" + this.producerMetadata + "]";
    }

    public void stop() {
        this.producer.close();
    }
}

