/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.Map;
import java.util.Properties;
import kafka.producer.Partitioner;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.EventHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.kafka.support.DefaultPartitioner;
import org.springframework.integration.kafka.support.ProducerMetadata;
import scala.collection.mutable.HashMap;

public class ProducerFactoryBean<K, V>
implements FactoryBean<kafka.javaapi.producer.Producer<K, V>> {
    private static final Log LOGGER = LogFactory.getLog(ProducerFactoryBean.class);
    private final String brokerList;
    private final ProducerMetadata<K, V> producerMetadata;
    private Properties producerProperties = new Properties();

    public ProducerFactoryBean(ProducerMetadata<K, V> producerMetadata, String brokerList, Properties producerProperties) {
        this.producerMetadata = producerMetadata;
        this.brokerList = brokerList;
        if (producerProperties != null) {
            this.producerProperties = producerProperties;
        }
    }

    public ProducerFactoryBean(ProducerMetadata<K, V> producerMetadata, String brokerList) {
        this(producerMetadata, brokerList, null);
    }

    public kafka.javaapi.producer.Producer<K, V> getObject() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.producerProperties);
        props.put("metadata.broker.list", this.brokerList);
        props.put("compression.codec", this.producerMetadata.getCompressionCodec());
        if (this.producerMetadata.isAsync()) {
            props.put("producer.type", "async");
            if (this.producerMetadata.getBatchNumMessages() != null) {
                props.put("batch.num.messages", this.producerMetadata.getBatchNumMessages());
            }
        }
        LOGGER.info((Object)("Using producer properties => " + props));
        ProducerConfig config = new ProducerConfig(props);
        DefaultEventHandler eventHandler = new DefaultEventHandler(config, (Partitioner)(this.producerMetadata.getPartitioner() == null ? new DefaultPartitioner() : this.producerMetadata.getPartitioner()), this.producerMetadata.getValueEncoder(), this.producerMetadata.getKeyEncoder(), new ProducerPool(config), new HashMap());
        Producer prod = new Producer(config, (EventHandler)eventHandler);
        return new kafka.javaapi.producer.Producer(prod);
    }

    public Class<?> getObjectType() {
        return kafka.javaapi.producer.Producer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

