/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import kafka.producer.Partitioner;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.Encoder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.beans.factory.InitializingBean;

public class ProducerMetadata<K, V>
implements InitializingBean {
    private Encoder<K> keyEncoder;
    private Encoder<V> valueEncoder;
    private Class<K> keyClassType;
    private Class<V> valueClassType;
    private final String topic;
    private String compressionCodec = "default";
    private Partitioner partitioner;
    private boolean async = false;
    private String batchNumMessages;

    public ProducerMetadata(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public Encoder<K> getKeyEncoder() {
        return this.keyEncoder;
    }

    public void setKeyEncoder(Encoder<K> keyEncoder) {
        this.keyEncoder = keyEncoder;
    }

    public Encoder<V> getValueEncoder() {
        return this.valueEncoder;
    }

    public void setValueEncoder(Encoder<V> valueEncoder) {
        this.valueEncoder = valueEncoder;
    }

    public Class<K> getKeyClassType() {
        return this.keyClassType;
    }

    public void setKeyClassType(Class<K> keyClassType) {
        this.keyClassType = keyClassType;
    }

    public Class<V> getValueClassType() {
        return this.valueClassType;
    }

    public void setValueClassType(Class<V> valueClassType) {
        this.valueClassType = valueClassType;
    }

    public String getCompressionCodec() {
        if (this.compressionCodec.equalsIgnoreCase("gzip")) {
            return "1";
        }
        if (this.compressionCodec.equalsIgnoreCase("snappy")) {
            return "2";
        }
        return "0";
    }

    public void setCompressionCodec(String compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.valueEncoder == null) {
            this.setValueEncoder((Encoder<V>)new DefaultEncoder(null));
        }
        if (this.keyEncoder == null) {
            this.setKeyEncoder(this.getValueEncoder());
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getBatchNumMessages() {
        return this.batchNumMessages;
    }

    public void setBatchNumMessages(String batchNumMessages) {
        this.batchNumMessages = batchNumMessages;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProducerMetadata [keyEncoder=").append(this.keyEncoder).append(", valueEncoder=").append(this.valueEncoder).append(", topic=").append(this.topic).append(", compressionCodec=").append(this.compressionCodec).append(", partitioner=").append(this.partitioner).append(", async=").append(this.async).append(", batchNumMessages=").append(this.batchNumMessages).append("]");
        return builder.toString();
    }
}

