/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.integration.sftp.session.JSchSessionWrapper;
import org.springframework.integration.sftp.session.JschLogger;
import org.springframework.integration.sftp.session.SftpSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSftpSessionFactory
implements SessionFactory<ChannelSftp.LsEntry>,
SharedSessionCapable {
    private volatile String host;
    private volatile int port = 22;
    private volatile String user;
    private volatile String password;
    private volatile String knownHosts;
    private volatile Resource privateKey;
    private volatile String privateKeyPassphrase;
    private volatile Properties sessionConfig;
    private volatile Proxy proxy;
    private volatile SocketFactory socketFactory;
    private volatile Integer timeout;
    private volatile String clientVersion;
    private volatile String hostKeyAlias;
    private volatile Integer serverAliveInterval;
    private volatile Integer serverAliveCountMax;
    private volatile Boolean enableDaemonThread;
    private final JSch jsch;
    private final boolean isSharedSession;
    private volatile JSchSessionWrapper sharedJschSession;
    private final ReentrantReadWriteLock sharedSessionLock = new ReentrantReadWriteLock();

    public DefaultSftpSessionFactory() {
        this(false);
    }

    public DefaultSftpSessionFactory(boolean isSharedSession) {
        this(new JSch(), isSharedSession);
    }

    public DefaultSftpSessionFactory(JSch jsch, boolean isSharedSession) {
        this.jsch = jsch;
        this.isSharedSession = isSharedSession;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public void setPrivateKey(Resource privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public void setSessionConfig(Properties sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void setHostKeyAlias(String hostKeyAlias) {
        this.hostKeyAlias = hostKeyAlias;
    }

    public void setServerAliveInterval(Integer serverAliveInterval) {
        this.serverAliveInterval = serverAliveInterval;
    }

    public void setServerAliveCountMax(Integer serverAliveCountMax) {
        this.serverAliveCountMax = serverAliveCountMax;
    }

    public void setEnableDaemonThread(Boolean enableDaemonThread) {
        this.enableDaemonThread = enableDaemonThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.springframework.integration.file.remote.session.Session<ChannelSftp.LsEntry> getSession() {
        Assert.hasText((String)this.host, (String)"host must not be empty");
        Assert.hasText((String)this.user, (String)"user must not be empty");
        Assert.isTrue((this.port >= 0 ? 1 : 0) != 0, (String)"port must be a positive number");
        Assert.isTrue((StringUtils.hasText((String)this.password) || this.privateKey != null ? 1 : 0) != 0, (String)"either a password or a private key is required");
        try {
            JSchSessionWrapper jschSession;
            if (this.isSharedSession) {
                block11: {
                    this.sharedSessionLock.readLock().lock();
                    try {
                        if (this.sharedJschSession != null && this.sharedJschSession.isConnected()) break block11;
                        this.sharedSessionLock.readLock().unlock();
                        this.sharedSessionLock.writeLock().lock();
                        try {
                            if (this.sharedJschSession == null || !this.sharedJschSession.isConnected()) {
                                this.sharedJschSession = new JSchSessionWrapper(this.initJschSession());
                            }
                        }
                        finally {
                            this.sharedSessionLock.readLock().lock();
                            this.sharedSessionLock.writeLock().unlock();
                        }
                    }
                    finally {
                        this.sharedSessionLock.readLock().unlock();
                    }
                }
                jschSession = this.sharedJschSession;
            } else {
                jschSession = new JSchSessionWrapper(this.initJschSession());
            }
            SftpSession sftpSession = new SftpSession(jschSession);
            sftpSession.connect();
            jschSession.addChannel();
            return sftpSession;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create SFTP Session", e);
        }
    }

    private Session initJschSession() throws Exception {
        JSch.setLogger((Logger)new JschLogger());
        if (this.port <= 0) {
            this.port = 22;
        }
        if (StringUtils.hasText((String)this.knownHosts)) {
            this.jsch.setKnownHosts(this.knownHosts);
        }
        if (this.privateKey != null) {
            String privateKeyFilePath = this.privateKey.getFile().getAbsolutePath();
            if (StringUtils.hasText((String)this.privateKeyPassphrase)) {
                this.jsch.addIdentity(privateKeyFilePath, this.privateKeyPassphrase);
            } else {
                this.jsch.addIdentity(privateKeyFilePath);
            }
        }
        Session jschSession = this.jsch.getSession(this.user, this.host, this.port);
        if (this.sessionConfig != null) {
            jschSession.setConfig(this.sessionConfig);
        }
        if (StringUtils.hasText((String)this.password)) {
            jschSession.setPassword(this.password);
        }
        jschSession.setUserInfo((UserInfo)new OptimisticUserInfoImpl(this.password));
        try {
            if (this.proxy != null) {
                jschSession.setProxy(this.proxy);
            }
            if (this.socketFactory != null) {
                jschSession.setSocketFactory(this.socketFactory);
            }
            if (this.timeout != null) {
                jschSession.setTimeout(this.timeout.intValue());
            }
            if (StringUtils.hasText((String)this.clientVersion)) {
                jschSession.setClientVersion(this.clientVersion);
            }
            if (StringUtils.hasText((String)this.hostKeyAlias)) {
                jschSession.setHostKeyAlias(this.hostKeyAlias);
            }
            if (this.serverAliveInterval != null) {
                jschSession.setServerAliveInterval(this.serverAliveInterval.intValue());
            }
            if (this.serverAliveCountMax != null) {
                jschSession.setServerAliveCountMax(this.serverAliveCountMax.intValue());
            }
            if (this.enableDaemonThread != null) {
                jschSession.setDaemonThread(this.enableDaemonThread.booleanValue());
            }
        }
        catch (Exception e) {
            throw new BeanCreationException("Attempt to set additional properties of the com.jcraft.jsch.Session resulted in error: " + e.getMessage(), (Throwable)e);
        }
        return jschSession;
    }

    public final boolean isSharedSession() {
        return this.isSharedSession;
    }

    public void resetSharedSession() {
        Assert.state((boolean)this.isSharedSession, (String)"Shared sessions are not being used");
        this.sharedJschSession = null;
    }

    private static class OptimisticUserInfoImpl
    implements UserInfo,
    UIKeyboardInteractive {
        private final String password;

        public OptimisticUserInfoImpl(String password) {
            this.password = password;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public boolean promptYesNo(String string) {
            return true;
        }

        public void showMessage(String string) {
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            return null;
        }
    }
}

