/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractMessageHandler;

public class ByteStreamWritingMessageHandler
extends AbstractMessageHandler {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final BufferedOutputStream stream;

    public ByteStreamWritingMessageHandler(OutputStream stream) {
        this(stream, -1);
    }

    public ByteStreamWritingMessageHandler(OutputStream stream, int bufferSize) {
        this.stream = bufferSize > 0 ? new BufferedOutputStream(stream, bufferSize) : new BufferedOutputStream(stream);
    }

    protected void handleMessageInternal(Message<?> message) {
        Object payload = message.getPayload();
        if (payload == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " received null object"));
            }
            return;
        }
        try {
            if (payload instanceof String) {
                this.stream.write(((String)payload).getBytes());
            } else if (payload instanceof byte[]) {
                this.stream.write((byte[])payload);
            } else {
                throw new MessagingException(((Object)((Object)this)).getClass().getSimpleName() + " only supports byte array and String-based messages");
            }
            this.stream.flush();
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in target", (Throwable)e);
        }
    }
}

