/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.config.java.process.ConfigurationListenerRegistry;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.config.java.process.ProcessUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Ordered;
import org.springframework.core.io.ResourceLoader;

public class ConfigurationPostProcessor
implements BeanFactoryPostProcessor,
Ordered,
ResourceLoaderAware,
ApplicationContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ConfigurationListenerRegistry configurationListenerRegistry;
    private BeanNamingStrategy namingStrategy;
    private ConfigurableApplicationContext applicationContext;
    private ResourceLoader resourceLoader;
    private boolean hasRun;

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setConfigurationListenerRegistry(ConfigurationListenerRegistry configurationListenerRegistry) {
        this.configurationListenerRegistry = configurationListenerRegistry;
    }

    public void setNamingStrategy(BeanNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        if (ac instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)ac;
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        if (this.hasRun) {
            throw new IllegalStateException("ConfigurationPostProcessor cannot run on two BeanFactories");
        }
        this.hasRun = true;
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            Class<?> clazz = ProcessUtils.getBeanClass(beanName, beanFactory);
            if (clazz == null || !ConfigurationProcessor.isConfigurationClass(clazz, this.configurationListenerRegistry)) continue;
            ConfigurationProcessor processor = this.applicationContext != null ? new ConfigurationProcessor(this.applicationContext) : new ConfigurationProcessor(beanFactory);
            if (this.configurationListenerRegistry != null) {
                processor.setConfigurationListenerRegistry(this.configurationListenerRegistry);
            }
            if (this.namingStrategy != null) {
                processor.setBeanNamingStrategy(this.namingStrategy);
            }
            if (this.resourceLoader != null) {
                processor.setResourceLoader(this.resourceLoader);
            }
            processor.afterPropertiesSet();
            processor.processConfigurationBean(beanName, clazz);
        }
    }
}

