/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.springframework.modulith.aptk.tools.MessagerUtils;
import org.springframework.modulith.aptk.tools.corematcher.ValidationMessage;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapperValidatorInterface;

public class ElementWrapperValidator<WRAPPER extends ElementWrapper<?>> {
    private final WRAPPER wrapper;
    private final MessageConfig messageConfig = new MessageConfig();
    private final List<Predicate<WRAPPER>> checks = new ArrayList<Predicate<WRAPPER>>();

    public ElementWrapperValidator(WRAPPER wrapper) {
        this.wrapper = wrapper;
    }

    public ElementWrapperValidatorInterface.FirstValidation<WRAPPER> start() {
        return new FirstValidationImpl();
    }

    private void addCustomMessage(ValidationMessage message, Object ... vars) {
        this.messageConfig.customMessage = message;
        this.messageConfig.customMessageVars = vars;
    }

    private void addCheck(Predicate<WRAPPER> predicate) {
        this.checks.add(predicate);
    }

    public static <WRAPPER extends ElementWrapper<? extends Element>> ElementWrapperValidatorInterface.FirstValidation<WRAPPER> startValidation(WRAPPER wrapper) {
        return new ElementWrapperValidator<WRAPPER>(wrapper).start();
    }

    static class MessageConfig {
        Diagnostic.Kind kind = Diagnostic.Kind.ERROR;
        ValidationMessage customMessage = new DummyValidationMessage(null, "Validation FAILED!");
        Object[] customMessageVars = null;

        MessageConfig() {
        }
    }

    class FirstValidationImpl
    implements ElementWrapperValidatorInterface.FirstValidation<WRAPPER> {
        FirstValidationImpl() {
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScope<WRAPPER> asInfo() {
            ((ElementWrapperValidator)ElementWrapperValidator.this).messageConfig.kind = Diagnostic.Kind.NOTE;
            return new FirstValidationWithScopeImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScope<WRAPPER> asWarning() {
            ((ElementWrapperValidator)ElementWrapperValidator.this).messageConfig.kind = Diagnostic.Kind.WARNING;
            return new FirstValidationWithScopeImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScope<WRAPPER> asMandatoryWarning() {
            ((ElementWrapperValidator)ElementWrapperValidator.this).messageConfig.kind = Diagnostic.Kind.MANDATORY_WARNING;
            return new FirstValidationWithScopeImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScope<WRAPPER> asError() {
            ((ElementWrapperValidator)ElementWrapperValidator.this).messageConfig.kind = Diagnostic.Kind.ERROR;
            return new FirstValidationWithScopeImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScopeAndCustomMessage<WRAPPER> withCustomMessage(ValidationMessage message, Object ... vars) {
            ElementWrapperValidator.this.addCustomMessage(message, vars);
            return new FirstValidationWithScopeAndCustomMessageImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScopeAndCustomMessage<WRAPPER> withCustomMessage(String message, Object ... vars) {
            ElementWrapperValidator.this.addCustomMessage(new DummyValidationMessage(null, message), vars);
            return new FirstValidationWithScopeAndCustomMessageImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FollowUpValidationOrEndValidation<WRAPPER> check(Predicate<WRAPPER> predicate) {
            ElementWrapperValidator.this.addCheck(predicate);
            return new FollowUpValidationOrEndValidationImpl();
        }
    }

    class FollowUpValidationOrEndValidationImpl
    implements ElementWrapperValidatorInterface.FollowUpValidationOrEndValidation<WRAPPER> {
        FollowUpValidationOrEndValidationImpl() {
        }

        @Override
        public ElementWrapperValidatorInterface.FollowUpValidationOrEndValidation<WRAPPER> and(Predicate<WRAPPER> predicate) {
            ElementWrapperValidator.this.addCheck(predicate);
            return new FollowUpValidationOrEndValidationImpl();
        }

        @Override
        public boolean validate() {
            boolean result = true;
            for (Predicate check : ElementWrapperValidator.this.checks) {
                result &= check.test(ElementWrapperValidator.this.wrapper);
            }
            return result;
        }

        @Override
        public boolean validateAndIssueMessages() {
            boolean result = this.validate();
            if (!result) {
                MessagerUtils.printMessage(((ElementWrapperValidator)ElementWrapperValidator.this).wrapper.element, Diagnostic.Kind.ERROR, ((ElementWrapperValidator)ElementWrapperValidator.this).messageConfig.customMessage, ((ElementWrapperValidator)ElementWrapperValidator.this).messageConfig.customMessageVars);
            }
            return result;
        }
    }

    class FirstValidationWithScopeAndCustomMessageImpl
    implements ElementWrapperValidatorInterface.FirstValidationWithScopeAndCustomMessage<WRAPPER> {
        FirstValidationWithScopeAndCustomMessageImpl() {
        }

        @Override
        public ElementWrapperValidatorInterface.FollowUpValidationOrEndValidation<WRAPPER> check(Predicate<WRAPPER> predicate) {
            ElementWrapperValidator.this.addCheck(predicate);
            return new FollowUpValidationOrEndValidationImpl();
        }
    }

    class FirstValidationWithScopeImpl
    implements ElementWrapperValidatorInterface.FirstValidationWithScope<WRAPPER> {
        FirstValidationWithScopeImpl() {
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScopeAndCustomMessage<WRAPPER> withCustomMessage(ValidationMessage message, Object ... vars) {
            ElementWrapperValidator.this.addCustomMessage(message, vars);
            return new FirstValidationWithScopeAndCustomMessageImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FirstValidationWithScopeAndCustomMessage<WRAPPER> withCustomMessage(String message, Object ... vars) {
            ElementWrapperValidator.this.addCustomMessage(new DummyValidationMessage(null, message), vars);
            return new FirstValidationWithScopeAndCustomMessageImpl();
        }

        @Override
        public ElementWrapperValidatorInterface.FollowUpValidationOrEndValidation<WRAPPER> check(Predicate<WRAPPER> predicate) {
            ElementWrapperValidator.this.addCheck(predicate);
            return new FollowUpValidationOrEndValidationImpl();
        }
    }

    static class DummyValidationMessage
    implements ValidationMessage {
        private final String code;
        private final String message;

        public DummyValidationMessage(String code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

