/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModuleDependency;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ArchitecturallyEvidentType;
import org.springframework.modulith.core.DependencyType;
import org.springframework.modulith.core.EventType;
import org.springframework.modulith.core.FormattableType;
import org.springframework.modulith.core.Source;
import org.springframework.modulith.core.SpringBean;
import org.springframework.modulith.docs.CodeReplacingDocumentationSource;
import org.springframework.modulith.docs.ConfigurationProperties;
import org.springframework.modulith.docs.DocumentationSource;
import org.springframework.modulith.docs.Documenter;
import org.springframework.modulith.docs.SpringModulithDocumentationSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class Asciidoctor {
    private static String PLACEHOLDER = "\u00af\\_(\u30c4)_/\u00af";
    private static final Pattern JAVADOC_CODE = Pattern.compile("\\{\\@(link|code|literal)\\s*(.*?)\\}");
    private static final Pattern LINE_BREAKS = Pattern.compile("\\<\\s*br\\s*\\>");
    private static final Logger LOG = LoggerFactory.getLogger(Asciidoctor.class);
    private static final Optional<DocumentationSource> DOC_SOURCE = Asciidoctor.getSpringModulithDocsSource();
    private final ApplicationModules modules;
    private final String javaDocBase;
    private final Optional<DocumentationSource> docSource;

    private Asciidoctor(ApplicationModules modules, String javaDocBase) {
        Assert.notNull((Object)modules, (String)"Modules must not be null!");
        Assert.hasText((String)javaDocBase, (String)"Javadoc base must not be null or empty!");
        this.javaDocBase = javaDocBase;
        this.modules = modules;
        this.docSource = DOC_SOURCE.map(it -> new CodeReplacingDocumentationSource((DocumentationSource)it, this));
    }

    public static Asciidoctor withJavadocBase(ApplicationModules modules, @Nullable String javadocBase) {
        return new Asciidoctor(modules, javadocBase == null ? PLACEHOLDER : javadocBase);
    }

    public static Asciidoctor withoutJavadocBase(ApplicationModules modules) {
        return new Asciidoctor(modules, PLACEHOLDER);
    }

    public String toInlineCode(String source) {
        Optional<String> methodSignature;
        String[] parts = source.split("#");
        String type = parts[0];
        Optional<String> optional = methodSignature = parts.length == 2 ? Optional.of(parts[1]) : Optional.empty();
        if (type.isBlank()) {
            return methodSignature.map(Asciidoctor::toCode).orElse(source);
        }
        return this.modules.getModuleByType(type).flatMap(it -> it.getType(type)).map(it -> this.toOptionalLink((JavaClass)it, methodSignature)).orElseGet(() -> Asciidoctor.toCode(type));
    }

    public String toInlineCode(JavaClass type) {
        return this.toOptionalLink(type);
    }

    public String toInlineCode(SpringBean bean) {
        ArchitecturallyEvidentType type = bean.toArchitecturallyEvidentType();
        String base = this.toInlineCode(type);
        List interfaces = bean.getInterfacesWithinModule();
        if (interfaces.isEmpty()) {
            return base;
        }
        String interfacesAsString = interfaces.stream().map(this::toInlineCode).collect(Collectors.joining(", "));
        return "%s (via %s)".formatted(interfacesAsString, base);
    }

    private String withDocumentation(String base, JavaClass type) {
        return this.docSource.flatMap(it -> it.getDocumentation(type)).map(it -> base + " -- " + it).orElse(base);
    }

    public String renderSpringBeans(ApplicationModule module, Documenter.CanvasOptions options) {
        StringBuilder builder = new StringBuilder();
        Documenter.CanvasOptions.Groupings groupings = options.groupBeans(module);
        if (groupings.hasOnlyFallbackGroup()) {
            return this.toBulletPoints(groupings.byGrouping(Documenter.CanvasOptions.FALLBACK_GROUP));
        }
        groupings.forEach((grouping, beans) -> {
            if (beans.isEmpty()) {
                return;
            }
            if (builder.length() != 0) {
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
            }
            builder.append("_").append(grouping.getName()).append("_");
            if (grouping.getDescription() != null) {
                builder.append(" -- ").append(grouping.getDescription());
            }
            builder.append(System.lineSeparator());
            builder.append(System.lineSeparator());
            builder.append(this.toBulletPoints((List<SpringBean>)beans));
        });
        return builder.length() == 0 ? "None" : builder.toString();
    }

    public String renderPublishedEvents(ApplicationModule module) {
        List events = module.getPublishedEvents();
        if (events.isEmpty()) {
            return "none";
        }
        StringBuilder builder = new StringBuilder();
        for (EventType eventType : events) {
            if (!module.isExposed(eventType.getType())) continue;
            Optional<String> documentation = this.docSource.flatMap(it -> it.getDocumentation(eventType.getType())).map(" -- "::concat);
            builder.append("* ").append(this.toInlineCode(eventType.getType()));
            documentation.ifPresent(builder::append);
            if (!eventType.hasSources()) {
                builder.append(System.lineSeparator());
            } else {
                builder.append((documentation.isPresent() ? " C" : " c") + "reated by:");
                builder.append(System.lineSeparator());
            }
            for (Source source : eventType.getSources()) {
                builder.append("** ").append(this.toInlineCode(source.toString(module))).append(System.lineSeparator());
            }
        }
        return builder.toString();
    }

    public String renderEventsListenedTo(ApplicationModule module) {
        return module.getSpringBeans().stream().map(SpringBean::toArchitecturallyEvidentType).filter(ArchitecturallyEvidentType::isEventListener).flatMap(ArchitecturallyEvidentType::getReferenceMethods).map(it -> this.renderReferenceMethod((ArchitecturallyEvidentType.ReferenceMethod)it, 0)).collect(Collectors.joining(System.lineSeparator()));
    }

    public String renderConfigurationProperties(List<ConfigurationProperties.ModuleProperty> properties) {
        if (properties.isEmpty()) {
            return "none";
        }
        Stream<String> stream = properties.stream().map(it -> {
            String description;
            StringBuilder builder = new StringBuilder().append(Asciidoctor.toCode(it.name())).append(" -- ").append(this.toInlineCode(it.type()));
            String defaultValue = it.defaultValue();
            if (defaultValue != null && StringUtils.hasText((String)defaultValue)) {
                builder = builder.append(", default ").append(this.toInlineCode(defaultValue));
            }
            if ((description = it.description()) != null && StringUtils.hasText((String)description)) {
                builder = builder.append(". ").append(this.toAsciidoctor(description));
            }
            return builder.toString();
        });
        return this.toBulletPoints(stream);
    }

    private String toBulletPoints(List<SpringBean> beans) {
        return this.toBulletPoints(beans.stream().map(this::toInlineCode));
    }

    public String typesToBulletPoints(List<JavaClass> types) {
        return this.toBulletPoints(types.stream().map(it -> this.withDocumentation(this.toOptionalLink((JavaClass)it), (JavaClass)it)));
    }

    private String toBulletPoints(Stream<String> types) {
        return types.collect(Collectors.joining(System.lineSeparator() + "* ", "* ", ""));
    }

    public String toBulletPoint(String source) {
        return "* ".concat(source);
    }

    private String toOptionalLink(JavaClass source) {
        return this.toOptionalLink(source, Optional.empty());
    }

    private String toOptionalLink(JavaClass source, Optional<String> methodSignature) {
        ApplicationModule module = this.modules.getModuleByType(source).orElse(null);
        String formattable = FormattableType.of((JavaClass)source).getAbbreviatedFullName(module);
        String typeAndMethod = Asciidoctor.toCode(Asciidoctor.toTypeAndMethod(formattable, methodSignature));
        if (module == null || !source.getModifiers().contains(JavaModifier.PUBLIC) || !module.contains(source)) {
            return typeAndMethod;
        }
        String classPath = ClassUtils.convertClassNameToResourcePath((String)source.getFullName()).replace('$', '.');
        return Optional.ofNullable(this.javaDocBase == PLACEHOLDER ? null : this.javaDocBase).map(it -> it.concat("/").concat(classPath).concat(".html")).map(it -> Asciidoctor.toLink(typeAndMethod, it)).orElseGet(() -> typeAndMethod);
    }

    private static String toTypeAndMethod(String type, Optional<String> methodSignature) {
        return methodSignature.map(it -> type.concat("#").concat((String)it)).orElse(type);
    }

    private String toInlineCode(ArchitecturallyEvidentType type) {
        return this.withDocumentation(this.toInlineCode(type.getType()), type.getType());
    }

    private String renderReferenceMethod(ArchitecturallyEvidentType.ReferenceMethod it, int level) {
        JavaMethod method = it.getMethod();
        List<Class> exposedReferenceTypes = it.getReferenceTypes().stream().filter(type -> this.modules.getModuleByType(type).map(module -> module.isExposed(type)).orElse(true)).toList();
        if (exposedReferenceTypes.isEmpty()) {
            return "";
        }
        String isAsync = it.isAsync() ? "(async) " : "";
        String indent = "*".repeat(level + 1);
        return this.docSource.flatMap(source -> source.getDocumentation(method)).map(doc -> "%s %s %s-- %s".formatted(indent, this.toInlineCode(exposedReferenceTypes), isAsync, doc)).orElseGet(() -> "%s %s %s".formatted(indent, this.toInlineCode(exposedReferenceTypes), isAsync));
    }

    private String toInlineCode(Collection<Class<?>> types) {
        return types.stream().map(Class::getName).map(this::toInlineCode).collect(Collectors.joining(", "));
    }

    private static String toLink(String source, String href) {
        return "link:%s[%s]".formatted(href, source);
    }

    private static String toCode(String source) {
        return Asciidoctor.wrap(source, "`");
    }

    public static String startTable(String tableSpec) {
        return "[" + tableSpec + "]" + System.lineSeparator() + "|===" + System.lineSeparator();
    }

    public static String startOrEndTable() {
        return "|===" + System.lineSeparator();
    }

    public static String writeTableRow(String ... columns) {
        return Stream.of(columns).collect(Collectors.joining(System.lineSeparator() + "|", "|", System.lineSeparator()));
    }

    public String toAsciidoctor(String source) {
        Matcher matcher = JAVADOC_CODE.matcher(source);
        while (matcher.find()) {
            String type = matcher.group(2);
            source = source.replace(matcher.group(), this.toInlineCode(type));
        }
        source = source.replaceAll("<p>\\s*", System.lineSeparator() + "+" + System.lineSeparator());
        source = source.replace("</p>", "");
        source = LINE_BREAKS.matcher(source).replaceAll(System.lineSeparator());
        return source;
    }

    public String renderBeanReferences(ApplicationModule module) {
        String bullets = module.getDirectDependencies(this.modules, new DependencyType[]{DependencyType.USES_COMPONENT}).uniqueStream(ApplicationModuleDependency::getTargetType).map(it -> {
            JavaClass targetType = it.getTargetType();
            String result = "%s (in %s)".formatted(this.toInlineCode(targetType), it.getTargetModule().getDisplayName());
            return this.withDocumentation(result, targetType);
        }).map(this::toBulletPoint).collect(Collectors.joining(System.lineSeparator()));
        return bullets.isBlank() ? "None" : bullets;
    }

    public String renderModuleDescription(ApplicationModule module) {
        return this.docSource.flatMap(it -> it.getDocumentation(module.getBasePackage())).orElse("");
    }

    public String renderHeadline(int i, String modules) {
        return "=".repeat(i) + " " + modules + System.lineSeparator();
    }

    public String renderPlantUmlInclude(String componentsFilename) {
        return "plantuml::" + componentsFilename + "[,,format=svg]" + System.lineSeparator();
    }

    public String renderGeneralInclude(String componentsFilename) {
        return "include::" + componentsFilename + "[]" + System.lineSeparator();
    }

    private static Optional<DocumentationSource> getSpringModulithDocsSource() {
        return SpringModulithDocumentationSource.getInstance().map(it -> {
            LOG.debug("Using Javadoc extracted by Spring Modulith in {}.", (Object)SpringModulithDocumentationSource.getMetadataLocation());
            return it;
        });
    }

    private static final String wrap(String source, String chars) {
        return chars + source + chars;
    }
}

