/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events;

import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.ResolvableTypeProvider;
import org.springframework.modulith.events.RoutingTarget;
import org.springframework.util.Assert;

public class EventExternalized<S, T>
implements ResolvableTypeProvider {
    private final S event;
    private final Object mapped;
    private final RoutingTarget target;
    private final @Nullable T brokerResult;
    private final ResolvableType type;

    public EventExternalized(S event, Object mapped, RoutingTarget target, @Nullable T brokerResult) {
        Assert.notNull(event, (String)"Source event must not be null!");
        Assert.notNull((Object)mapped, (String)"Mapped event must not be null!");
        Assert.notNull((Object)target, (String)"Routing target must not be null!");
        this.event = event;
        this.mapped = mapped;
        this.target = target;
        this.brokerResult = brokerResult;
        this.type = ResolvableType.forClassWithGenerics(EventExternalized.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forInstance(event), brokerResult == null ? ResolvableType.forClass(Object.class) : ResolvableType.forInstance(brokerResult)});
    }

    public S getEvent() {
        return this.event;
    }

    public Class<S> getEventType() {
        return this.type.getGeneric(new int[]{0}).resolve(Object.class);
    }

    public Object getMapped() {
        return this.mapped;
    }

    public RoutingTarget getTarget() {
        return this.target;
    }

    public @Nullable T getBrokerResult() {
        return this.brokerResult;
    }

    public @NonNull ResolvableType getResolvableType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EventExternalized)) {
            return false;
        }
        EventExternalized that = (EventExternalized)obj;
        return Objects.equals(this.event, that.event) && Objects.equals(this.mapped, that.mapped) && Objects.equals(this.brokerResult, that.brokerResult);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.mapped, this.brokerResult);
    }
}

