/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events;

import java.time.Duration;
import java.util.function.Predicate;
import org.springframework.modulith.events.EventPublication;
import org.springframework.util.Assert;

public class ResubmissionOptions {
    private final int maxInFlight;
    private final int batchSize;
    private final Duration minAge;
    private final Predicate<EventPublication> filter;

    private ResubmissionOptions(int maxInFlight, int batchSize, Duration minAge, Predicate<EventPublication> filter) {
        Assert.isTrue((maxInFlight > 0 ? 1 : 0) != 0, (String)"Max in flight number must be greater than zero!");
        Assert.isTrue((batchSize > 0 ? 1 : 0) != 0, (String)"Batch size must be greater than zero!");
        Assert.notNull((Object)minAge, (String)"Minimum age must not be null!");
        Assert.isTrue((!minAge.isNegative() ? 1 : 0) != 0, (String)"Minimum age must not be negative!");
        Assert.notNull(filter, (String)"Filter must not be null!");
        this.maxInFlight = maxInFlight;
        this.batchSize = batchSize;
        this.minAge = minAge;
        this.filter = filter;
    }

    public static ResubmissionOptions defaults() {
        return new ResubmissionOptions(Integer.MAX_VALUE, 100, Duration.ZERO, __ -> true);
    }

    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    public ResubmissionOptions withMaxInFlight(int maxInFlight) {
        return new ResubmissionOptions(maxInFlight, this.batchSize, this.minAge, this.filter);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ResubmissionOptions withBatchSize(int batchSize) {
        return new ResubmissionOptions(this.maxInFlight, batchSize, this.minAge, this.filter);
    }

    public Duration getMinAge() {
        return this.minAge;
    }

    public ResubmissionOptions withMinAge(Duration minAge) {
        return new ResubmissionOptions(this.maxInFlight, this.batchSize, minAge, this.filter);
    }

    public Predicate<EventPublication> getFilter() {
        return this.filter;
    }

    public ResubmissionOptions withFilter(Predicate<EventPublication> filter) {
        return new ResubmissionOptions(this.maxInFlight, this.batchSize, this.minAge, filter);
    }
}

