-- oracle database support 'create xx if not exists' from 23c, lower version should create table and index manually
CREATE TABLE IF NOT EXISTS EVENT_PUBLICATION_ARCHIVE
(
  ID                     VARCHAR2(36) NOT NULL,
  LISTENER_ID            VARCHAR2(512) NOT NULL,
  EVENT_TYPE             VARCHAR2(512) NOT NULL,
  SERIALIZED_EVENT       VARCHAR2(4000) NOT NULL,
  PUBLICATION_DATE       TIMESTAMP(6) NOT NULL,
  COMPLETION_DATE        TIMESTAMP(6),
  STATUS                 VARCHAR(20),
  COMPLETION_ATTEMPTS    INT,
  LAST_RESUBMISSION_DATE TIMESTAMP(6),
  CONSTRAINT EVENT_PUBLICATION_ARCHIVE_PK PRIMARY KEY(ID)
);

CREATE INDEX IF NOT EXISTS EVENT_PUBLICATION_ARCHIVE_BY_LISTENER_ID_AND_SERIALIZED_EVENT_IDX ON EVENT_PUBLICATION_ARCHIVE (LISTENER_ID, SERIALIZED_EVENT);
CREATE INDEX IF NOT EXISTS EVENT_PUBLICATION_ARCHIVE_BY_COMPLETION_DATE_IDX ON EVENT_PUBLICATION_ARCHIVE (COMPLETION_DATE);
