/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.util.Collection;
import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.modulith.events.jdbc.JdbcRepositorySettings;
import org.springframework.util.Assert;

public class DatabaseSchemaLocator {
    private final ResourceLoader resourceLoader;

    DatabaseSchemaLocator(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null!");
        this.resourceLoader = resourceLoader;
    }

    Collection<Resource> getSchemaResource(JdbcRepositorySettings settings) {
        Assert.notNull((Object)settings, (String)"JdbcRepositorySettings must not be null!");
        Function<String, String> loader = "classpath:"::concat;
        return settings.loadSchema(loader.andThen(arg_0 -> ((ResourceLoader)this.resourceLoader).getResource(arg_0)));
    }
}

