/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.modulith.events.EventPublication;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.core.TargetEventPublication;
import org.springframework.modulith.events.jdbc.JdbcRepositorySettings;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class JdbcEventPublicationRepository
implements EventPublicationRepository,
BeanClassLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcEventPublicationRepository.class);
    private static final String SQL_STATEMENT_INSERT = "INSERT INTO %s (ID, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT)\nVALUES (?, ?, ?, ?, ?)\n";
    private static final String SQL_STATEMENT_FIND_COMPLETED = "SELECT ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT\nFROM %s\nWHERE COMPLETION_DATE IS NOT NULL\nORDER BY PUBLICATION_DATE ASC\n";
    private static final String SQL_STATEMENT_FIND_INCOMPLETE = "SELECT ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT\nFROM %s\nWHERE COMPLETION_DATE IS NULL\nORDER BY PUBLICATION_DATE ASC\n";
    private static final String SQL_STATEMENT_FIND_INCOMPLETE_PUBLISHED_BEFORE = "SELECT ID, COMPLETION_DATE, EVENT_TYPE, LISTENER_ID, PUBLICATION_DATE, SERIALIZED_EVENT\nFROM %s\nWHERE\n\t\tCOMPLETION_DATE IS NULL\n\t\tAND PUBLICATION_DATE < ?\nORDER BY PUBLICATION_DATE ASC\n";
    private static final String SQL_STATEMENT_UPDATE_BY_EVENT_AND_LISTENER_ID = "UPDATE %s\nSET COMPLETION_DATE = ?\nWHERE\n\t\tLISTENER_ID = ?\n\t\tAND COMPLETION_DATE IS NULL\n\t\tAND SERIALIZED_EVENT = ?\n";
    private static final String SQL_STATEMENT_UPDATE_BY_ID = "UPDATE %s\nSET COMPLETION_DATE = ?\nWHERE\n\t\tID = ?\n";
    private static final String SQL_STATEMENT_FIND_BY_EVENT_AND_LISTENER_ID = "SELECT *\nFROM %s\nWHERE\n\t\tSERIALIZED_EVENT = ?\n\t\tAND LISTENER_ID = ?\n\t\tAND COMPLETION_DATE IS NULL\nORDER BY PUBLICATION_DATE\n";
    private static final String SQL_STATEMENT_DELETE = "DELETE\nFROM %s\nWHERE\n\t\tID IN\n";
    private static final String SQL_STATEMENT_DELETE_BY_EVENT_AND_LISTENER_ID = "DELETE FROM %s\nWHERE\n\t\tLISTENER_ID = ?\n\t\tAND SERIALIZED_EVENT = ?\n";
    private static final String SQL_STATEMENT_DELETE_BY_ID = "DELETE\nFROM %s\nWHERE\n\t\tID = ?\n";
    private static final String SQL_STATEMENT_DELETE_COMPLETED = "DELETE\nFROM %s\nWHERE\n\t\tCOMPLETION_DATE IS NOT NULL\n";
    private static final String SQL_STATEMENT_DELETE_COMPLETED_BEFORE = "DELETE\nFROM %s\nWHERE\n\t\tCOMPLETION_DATE < ?\n";
    private static final String SQL_STATEMENT_COPY_TO_ARCHIVE_BY_ID = "-- Only copy if no entry in target table\nINSERT INTO %s (ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, COMPLETION_DATE)\nSELECT ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, ?\n \tFROM %s\n \tWHERE ID = ?\n \t  AND NOT EXISTS (SELECT 1 FROM %s WHERE ID = EVENT_PUBLICATION.ID)\n";
    private static final String SQL_STATEMENT_COPY_TO_ARCHIVE_BY_EVENT_AND_LISTENER_ID = "-- Only copy if no entry in target table\nINSERT INTO %s (ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, COMPLETION_DATE)\nSELECT ID, LISTENER_ID, EVENT_TYPE, SERIALIZED_EVENT, PUBLICATION_DATE, ?\n \tFROM %s\n \tWHERE LISTENER_ID = ?\n\t  AND SERIALIZED_EVENT = ?\n\t  AND NOT EXISTS (SELECT 1 FROM %s WHERE ID = EVENT_PUBLICATION.ID)\n";
    private static final int DELETE_BATCH_SIZE = 100;
    private final JdbcOperations operations;
    private final EventSerializer serializer;
    private final JdbcRepositorySettings settings;
    private @Nullable ClassLoader classLoader;
    private final String sqlStatementInsert;
    private final String sqlStatementFindCompleted;
    private final String sqlStatementFindIncomplete;
    private final String sqlStatementFindIncompleteBefore;
    private final String sqlStatementUpdateByEventAndListenerId;
    private final String sqlStatementUpdateById;
    private final String sqlStatementFindByEventAndListenerId;
    private final String sqlStatementDelete;
    private final String sqlStatementDeleteByEventAndListenerId;
    private final String sqlStatementDeleteById;
    private final String sqlStatementDeleteCompleted;
    private final String sqlStatementDeleteCompletedBefore;
    private final String sqlStatementCopyToArchive;
    private final String sqlStatementCopyToArchiveByEventAndListenerId;

    public JdbcEventPublicationRepository(JdbcOperations operations, EventSerializer serializer, JdbcRepositorySettings settings) {
        Assert.notNull((Object)operations, (String)"JdbcOperations must not be null!");
        Assert.notNull((Object)serializer, (String)"EventSerializer must not be null!");
        Assert.notNull((Object)settings, (String)"DatabaseType must not be null!");
        this.operations = operations;
        this.serializer = serializer;
        this.settings = settings;
        String schema = settings.getSchema();
        Object table = ObjectUtils.isEmpty((Object)schema) ? "EVENT_PUBLICATION" : schema + ".EVENT_PUBLICATION";
        Object completedTable = settings.isArchiveCompletion() ? (String)table + "_ARCHIVE" : table;
        this.sqlStatementInsert = SQL_STATEMENT_INSERT.formatted(table);
        this.sqlStatementFindCompleted = SQL_STATEMENT_FIND_COMPLETED.formatted(completedTable);
        this.sqlStatementFindIncomplete = SQL_STATEMENT_FIND_INCOMPLETE.formatted(table);
        this.sqlStatementFindIncompleteBefore = SQL_STATEMENT_FIND_INCOMPLETE_PUBLISHED_BEFORE.formatted(table);
        this.sqlStatementUpdateByEventAndListenerId = SQL_STATEMENT_UPDATE_BY_EVENT_AND_LISTENER_ID.formatted(table);
        this.sqlStatementUpdateById = SQL_STATEMENT_UPDATE_BY_ID.formatted(table);
        this.sqlStatementFindByEventAndListenerId = SQL_STATEMENT_FIND_BY_EVENT_AND_LISTENER_ID.formatted(table);
        this.sqlStatementDelete = SQL_STATEMENT_DELETE.formatted(table);
        this.sqlStatementDeleteByEventAndListenerId = SQL_STATEMENT_DELETE_BY_EVENT_AND_LISTENER_ID.formatted(table);
        this.sqlStatementDeleteById = SQL_STATEMENT_DELETE_BY_ID.formatted(table);
        this.sqlStatementDeleteCompleted = SQL_STATEMENT_DELETE_COMPLETED.formatted(completedTable);
        this.sqlStatementDeleteCompletedBefore = SQL_STATEMENT_DELETE_COMPLETED_BEFORE.formatted(completedTable);
        this.sqlStatementCopyToArchive = SQL_STATEMENT_COPY_TO_ARCHIVE_BY_ID.formatted(completedTable, table, completedTable);
        this.sqlStatementCopyToArchiveByEventAndListenerId = SQL_STATEMENT_COPY_TO_ARCHIVE_BY_EVENT_AND_LISTENER_ID.formatted(completedTable, table, completedTable);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Transactional
    public TargetEventPublication create(TargetEventPublication publication) {
        String serializedEvent = this.serializeEvent(publication.getEvent());
        this.operations.update(this.sqlStatementInsert, new Object[]{this.uuidToDatabase(publication.getIdentifier()), publication.getEvent().getClass().getName(), publication.getTargetIdentifier().getValue(), Timestamp.from(publication.getPublicationDate()), serializedEvent});
        return publication;
    }

    @Transactional
    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        String targetIdentifier = identifier.getValue();
        Object serializedEvent = this.serializer.serialize(event);
        if (this.settings.isDeleteCompletion()) {
            this.operations.update(this.sqlStatementDeleteByEventAndListenerId, new Object[]{targetIdentifier, serializedEvent});
        } else if (this.settings.isArchiveCompletion()) {
            this.operations.update(this.sqlStatementCopyToArchiveByEventAndListenerId, new Object[]{Timestamp.from(completionDate), targetIdentifier, serializedEvent});
            this.operations.update(this.sqlStatementDeleteByEventAndListenerId, new Object[]{targetIdentifier, serializedEvent});
        } else {
            this.operations.update(this.sqlStatementUpdateByEventAndListenerId, new Object[]{Timestamp.from(completionDate), targetIdentifier, serializedEvent});
        }
    }

    @Transactional
    public void markCompleted(UUID identifier, Instant completionDate) {
        Object databaseId = this.uuidToDatabase(identifier);
        Timestamp timestamp = Timestamp.from(completionDate);
        if (this.settings.isDeleteCompletion()) {
            this.operations.update(this.sqlStatementDeleteById, new Object[]{databaseId});
        } else if (this.settings.isArchiveCompletion()) {
            this.operations.update(this.sqlStatementCopyToArchive, new Object[]{timestamp, databaseId});
            this.operations.update(this.sqlStatementDeleteById, new Object[]{databaseId});
        } else {
            this.operations.update(this.sqlStatementUpdateById, new Object[]{timestamp, databaseId});
        }
    }

    @Transactional(readOnly=true)
    public Optional<TargetEventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        List result = (List)this.operations.query(this.sqlStatementFindByEventAndListenerId, this::resultSetToPublications, new Object[]{this.serializeEvent(event), targetIdentifier.getValue()});
        return result == null ? Optional.empty() : result.stream().findFirst();
    }

    public List<TargetEventPublication> findCompletedPublications() {
        List result = (List)this.operations.query(this.sqlStatementFindCompleted, this::resultSetToPublications);
        return result == null ? Collections.emptyList() : result;
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublications() {
        List result = (List)this.operations.query(this.sqlStatementFindIncomplete, this::resultSetToPublications);
        return result == null ? Collections.emptyList() : result;
    }

    public List<TargetEventPublication> findIncompletePublicationsPublishedBefore(Instant instant) {
        List result = (List)this.operations.query(this.sqlStatementFindIncompleteBefore, this::resultSetToPublications, new Object[]{Timestamp.from(instant)});
        return result == null ? Collections.emptyList() : result;
    }

    public void deletePublications(List<UUID> identifiers) {
        List<Object> dbIdentifiers = identifiers.stream().map(this::uuidToDatabase).toList();
        JdbcEventPublicationRepository.batch(dbIdentifiers, 100).forEach(it -> this.operations.update(this.sqlStatementDelete.concat(JdbcEventPublicationRepository.toParameterPlaceholders(((Object[])it).length)), it));
    }

    public void deleteCompletedPublications() {
        this.operations.execute(this.sqlStatementDeleteCompleted);
    }

    public void deleteCompletedPublicationsBefore(Instant instant) {
        Assert.notNull((Object)instant, (String)"Instant must not be null!");
        this.operations.update(this.sqlStatementDeleteCompletedBefore, new Object[]{Timestamp.from(instant)});
    }

    public List<TargetEventPublication> findByStatus(EventPublication.Status status) {
        if (EventPublication.Status.COMPLETED == status) {
            return this.findCompletedPublications();
        }
        return Collections.emptyList();
    }

    public int countByStatus(EventPublication.Status status) {
        return this.findByStatus(status).size();
    }

    private String serializeEvent(Object event) {
        return this.serializer.serialize(event).toString();
    }

    private List<TargetEventPublication> resultSetToPublications(ResultSet resultSet) throws SQLException {
        ArrayList<TargetEventPublication> result = new ArrayList<TargetEventPublication>();
        while (resultSet.next()) {
            TargetEventPublication publication = this.resultSetToPublication(resultSet);
            if (publication == null) continue;
            result.add(publication);
        }
        return result;
    }

    private @Nullable TargetEventPublication resultSetToPublication(ResultSet rs) throws SQLException {
        UUID id = this.getUuidFromResultSet(rs);
        Class<?> eventClass = this.loadClass(id, rs.getString("EVENT_TYPE"));
        if (eventClass == null) {
            return null;
        }
        Timestamp completionDate = rs.getTimestamp("COMPLETION_DATE");
        Instant publicationDate = rs.getTimestamp("PUBLICATION_DATE").toInstant();
        String listenerId = rs.getString("LISTENER_ID");
        String serializedEvent = rs.getString("SERIALIZED_EVENT");
        return new JdbcEventPublication(id, publicationDate, listenerId, () -> this.serializer.deserialize((Object)serializedEvent, eventClass), completionDate == null ? null : completionDate.toInstant());
    }

    private Object uuidToDatabase(UUID id) {
        return this.settings.getDatabaseType().uuidToDatabase(id);
    }

    private UUID getUuidFromResultSet(ResultSet rs) throws SQLException {
        return this.settings.getDatabaseType().databaseToUUID(rs.getObject("ID"));
    }

    private @Nullable Class<?> loadClass(UUID id, String className) {
        try {
            return ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Event '{}' of unknown type '{}' found", (Object)id, (Object)className);
            return null;
        }
    }

    private static List<Object[]> batch(List<?> input, int batchSize) {
        int inputSize = input.size();
        return IntStream.range(0, (inputSize + batchSize - 1) / batchSize).mapToObj(i -> input.subList(i * batchSize, Math.min((i + 1) * batchSize, inputSize))).map(List::toArray).toList();
    }

    private static String toParameterPlaceholders(int length) {
        return IntStream.range(0, length).mapToObj(__ -> "?").collect(Collectors.joining(", ", "(", ")"));
    }

    private static class JdbcEventPublication
    implements TargetEventPublication {
        private final UUID id;
        private final Instant publicationDate;
        private final String listenerId;
        private final Supplier<Object> eventSupplier;
        private @Nullable Instant completionDate;
        private @Nullable Object event;

        public JdbcEventPublication(UUID id, Instant publicationDate, String listenerId, Supplier<Object> event, @Nullable Instant completionDate) {
            Assert.notNull((Object)id, (String)"Id must not be null!");
            Assert.notNull((Object)publicationDate, (String)"Publication date must not be null!");
            Assert.hasText((String)listenerId, (String)"Listener id must not be null or empty!");
            Assert.notNull(event, (String)"Event must not be null!");
            this.id = id;
            this.publicationDate = publicationDate;
            this.listenerId = listenerId;
            this.eventSupplier = event;
            this.completionDate = completionDate;
        }

        public UUID getIdentifier() {
            return this.id;
        }

        public Object getEvent() {
            if (this.event == null) {
                this.event = this.eventSupplier.get();
            }
            return this.event;
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.listenerId);
        }

        public Instant getPublicationDate() {
            return this.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.completionDate);
        }

        public boolean isPublicationCompleted() {
            return this.completionDate != null;
        }

        public void markCompleted(Instant instant) {
            this.completionDate = instant;
        }

        public EventPublication.Status getStatus() {
            return this.completionDate != null ? EventPublication.Status.COMPLETED : EventPublication.Status.PROCESSING;
        }

        public @Nullable Instant getLastResubmissionDate() {
            return null;
        }

        public int getCompletionAttempts() {
            return 1;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JdbcEventPublication)) {
                return false;
            }
            JdbcEventPublication that = (JdbcEventPublication)obj;
            return Objects.equals(this.completionDate, that.completionDate) && Objects.equals(this.id, that.id) && Objects.equals(this.listenerId, that.listenerId) && Objects.equals(this.publicationDate, that.publicationDate) && Objects.equals(this.getEvent(), that.getEvent());
        }

        public int hashCode() {
            return Objects.hash(this.completionDate, this.id, this.listenerId, this.publicationDate, this.getEvent());
        }
    }
}

