/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import io.micrometer.core.instrument.Counter;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.modulith.observability.ModulithEventMetrics;
import org.springframework.util.Assert;

public class CrossModuleEventCounterFactory
implements ModulithEventMetrics {
    private final SortedSet<ModulithMetricsCustomizer> customizers = new TreeSet<ModulithMetricsCustomizer>();
    private final SortedSet<ModulithMetricsCustomizer> creators = new TreeSet<ModulithMetricsCustomizer>();

    Counter.Builder createCounterBuilder(Object event) {
        Assert.notNull((Object)event, (String)"Event must not be null!");
        ModulithMetricsCustomizer creator = this.creators.stream().filter(it -> it.supports(event)).findFirst().orElse(ModulithMetricsCustomizer.DEFAULT);
        Counter.Builder builder = creator.createBuilder(event);
        return this.customizers.stream().sorted(Comparator.reverseOrder()).filter(it -> it.supports(event)).reduce(builder, (it, customizer) -> customizer.augment(event, (Counter.Builder)it), (l, r) -> r);
    }

    @Override
    public <T> ModulithEventMetrics customize(Class<T> type, Function<T, Counter.Builder> factory) {
        this.creators.add(new ModulithMetricsCustomizer(type, factory));
        return this;
    }

    @Override
    public <T> CrossModuleEventCounterFactory customize(Class<T> type, BiConsumer<T, Counter.Builder> consumer) {
        this.customizers.add(new ModulithMetricsCustomizer(type, consumer));
        return this;
    }

    private static class ModulithMetricsCustomizer
    implements Comparable<ModulithMetricsCustomizer> {
        private static final BiConsumer<Object, Counter.Builder> NO_OP = (event, builder) -> {};
        private static final Function<Object, Counter.Builder> DEFAULT_FACTORY = event -> Counter.builder((String)event.getClass().getSimpleName());
        public static final ModulithMetricsCustomizer DEFAULT = new ModulithMetricsCustomizer(Object.class, NO_OP);
        private final Class<?> type;
        private final Function<Object, Counter.Builder> creator;
        private final BiFunction<Object, Counter.Builder, Counter.Builder> customizer;

        public ModulithMetricsCustomizer(Class<?> type, Function<Object, Counter.Builder> creator) {
            this.type = type;
            this.creator = creator;
            this.customizer = (event, builder) -> builder;
        }

        public ModulithMetricsCustomizer(Class<?> type, BiConsumer<Object, Counter.Builder> creator) {
            this.type = type;
            this.creator = DEFAULT_FACTORY;
            this.customizer = (event, builder) -> {
                creator.accept(event, (Counter.Builder)builder);
                return builder;
            };
        }

        public Counter.Builder createBuilder(Object event) {
            return this.creator.apply(event);
        }

        public boolean supports(Object event) {
            return this.type.isInstance(event);
        }

        public Counter.Builder augment(Object event, Counter.Builder builder) {
            return this.customizer.apply(event, builder);
        }

        @Override
        public int compareTo(ModulithMetricsCustomizer that) {
            if (this.type.isAssignableFrom(that.type)) {
                return 1;
            }
            if (that.type.isAssignableFrom(this.type)) {
                return -1;
            }
            return this.type.getName().compareTo(that.type.getName());
        }
    }
}

