/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.observability.support.CrossModuleEventCounterFactory;
import org.springframework.modulith.observability.support.ModulithMetrics;
import org.springframework.modulith.observability.support.ModulithObservations;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.util.Assert;

public class ModuleEventListener
implements ApplicationListener<ApplicationEvent> {
    private final ApplicationModulesRuntime runtime;
    private final Supplier<ObservationRegistry> observationRegistry;
    private final Supplier<MeterRegistry> meterRegistry;
    private final CrossModuleEventCounterFactory factory;
    private final Map<Class<?>, Optional<ApplicationModule>> modulesByType;

    public ModuleEventListener(ApplicationModulesRuntime runtime, Supplier<ObservationRegistry> observationRegistrySupplier, Supplier<MeterRegistry> meterRegistrySupplier, CrossModuleEventCounterFactory counterFactory) {
        Assert.notNull((Object)runtime, (String)"ApplicationModulesRuntime must not be null!");
        Assert.notNull(observationRegistrySupplier, (String)"ObservationRegistry must not be null!");
        Assert.notNull(meterRegistrySupplier, (String)"MeterRegistry must not be null!");
        Assert.notNull((Object)counterFactory, (String)"ModulithEventCounterFactory must not be null!");
        this.runtime = runtime;
        this.observationRegistry = observationRegistrySupplier;
        this.meterRegistry = meterRegistrySupplier;
        this.factory = counterFactory;
        this.modulesByType = new ConcurrentHashMap();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Observation observation;
        if (!(event instanceof PayloadApplicationEvent)) {
            return;
        }
        PayloadApplicationEvent payloadEvent = (PayloadApplicationEvent)event;
        Object payload = payloadEvent.getPayload();
        Class<?> payloadType = payload.getClass();
        if (!this.runtime.isApplicationClass(payloadType)) {
            return;
        }
        ApplicationModule moduleByType = this.modulesByType.computeIfAbsent(payloadType, it -> this.runtime.get().getModuleByType(it)).orElse(null);
        if (moduleByType == null) {
            return;
        }
        MeterRegistry registry = this.meterRegistry.get();
        if (registry != null) {
            Counter.builder((String)ModulithMetrics.EVENTS.getName()).tags(new String[]{ModulithMetrics.LowKeys.EVENT_TYPE.name().toLowerCase(), payloadType.getSimpleName()}).tags(new String[]{ModulithMetrics.LowKeys.MODULE_NAME.name().toLowerCase(), moduleByType.getDisplayName()}).register(registry).increment();
            this.factory.createCounterBuilder(payload).register(registry).increment();
        }
        if ((observation = this.observationRegistry.get().getCurrentObservation()) == null) {
            return;
        }
        observation.event(Observation.Event.of((String)ModulithObservations.Events.EVENT_PUBLICATION_SUCCESS.getName(), (String)("Published " + payloadType.getName())));
    }
}

