/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.scheduling.annotation.AsyncAnnotationAdvisor;

class ModuleObservabilitySupport
implements BeanFactoryAware {
    private @Nullable AbstractAutoProxyCreator creator;

    ModuleObservabilitySupport() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.creator = (AbstractAutoProxyCreator)beanFactory.getBeanProvider(AbstractAutoProxyCreator.class).getIfAvailable();
    }

    protected final Object addAdvisor(Object bean, Advisor advisor) {
        return this.addAdvisor(bean, advisor, __ -> {});
    }

    protected final Object addAdvisor(Object bean, Advisor advisor, Consumer<ProxyFactory> customizer) {
        if (bean instanceof Advised) {
            Advised advised = (Advised)bean;
            advised.addAdvisor(ModuleObservabilitySupport.asyncAdvisorIndex(advised) + 1, advisor);
            return bean;
        }
        ProxyFactory factory = new ProxyFactory(bean);
        if (this.creator != null) {
            factory.copyFrom((ProxyConfig)this.creator);
        }
        customizer.accept(factory);
        factory.addAdvisor(advisor);
        return factory.getProxy(bean.getClass().getClassLoader());
    }

    private static int asyncAdvisorIndex(Advised advised) {
        Advisor[] advisors = advised.getAdvisors();
        for (int i = 0; i < advised.getAdvisorCount(); ++i) {
            if (!(advisors[i] instanceof AsyncAnnotationAdvisor)) continue;
            return i;
        }
        return -1;
    }
}

