/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.modulith.ApplicationModuleInitializer;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.FormattableType;
import org.springframework.util.Assert;

class LoggingApplicationModuleInitializerAdapter
implements ApplicationModuleInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingApplicationModuleInitializerAdapter.class);
    private final ApplicationModuleInitializer delegate;
    private final String label;

    private LoggingApplicationModuleInitializerAdapter(ApplicationModuleInitializer delegate, String label) {
        Assert.notNull((Object)delegate, (String)"ApplicationModuleInitializer must not be null!");
        Assert.hasText((String)label, (String)"Label must not be null or empty!");
        this.delegate = delegate;
        this.label = label;
    }

    public static ApplicationModuleInitializer of(ApplicationModuleInitializer initializer, ApplicationModules modules) {
        if (!LOGGER.isDebugEnabled()) {
            return initializer;
        }
        Class listenerType = AopUtils.getTargetClass((Object)initializer);
        FormattableType formattable = FormattableType.of((Class)listenerType);
        String formattedListenerType = modules.getModuleByType(listenerType).map(arg_0 -> ((FormattableType)formattable).getAbbreviatedFullName(arg_0)).orElseGet(() -> ((FormattableType)formattable).getAbbreviatedFullName());
        return new LoggingApplicationModuleInitializerAdapter(initializer, formattedListenerType);
    }

    public static ApplicationModuleInitializer of(ApplicationModuleInitializer initializer) {
        if (!LOGGER.isDebugEnabled()) {
            return initializer;
        }
        Class listenerType = AopUtils.getTargetClass((Object)initializer);
        String abbreviatedPackage = Stream.of(listenerType.getPackageName().split("\\.")).map(it -> it.substring(0, 1)).collect(Collectors.joining("."));
        return new LoggingApplicationModuleInitializerAdapter(initializer, abbreviatedPackage + "." + listenerType.getSimpleName());
    }

    public void initialize() {
        LOGGER.debug("Initializing {}.", (Object)this.label);
        this.delegate.initialize();
        LOGGER.debug("Initializing {} done.", (Object)this.label);
    }
}

