/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.jsonpath.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.modulith.runtime.jsonpath.Configuration;
import org.springframework.modulith.runtime.jsonpath.DocumentContext;
import org.springframework.modulith.runtime.jsonpath.ParseContext;
import org.springframework.modulith.runtime.jsonpath.internal.JsonContext;
import org.springframework.modulith.runtime.jsonpath.internal.Utils;

public class ParseContextImpl
implements ParseContext {
    private final Configuration configuration;

    public ParseContextImpl() {
        this(Configuration.defaultConfiguration());
    }

    public ParseContextImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public DocumentContext parse(Object json) {
        Utils.notNull(json, "json object can not be null");
        return new JsonContext(json, this.configuration);
    }

    @Override
    public DocumentContext parse(String json) {
        Utils.notEmpty(json, "json string can not be null or empty");
        Object obj = this.configuration.jsonProvider().parse(json);
        return new JsonContext(obj, this.configuration);
    }

    @Override
    public DocumentContext parseUtf8(byte[] json) {
        Utils.notEmpty(json, "json bytes can not be null or empty");
        Object obj = this.configuration.jsonProvider().parse(json);
        return new JsonContext(obj, this.configuration);
    }

    @Override
    public DocumentContext parse(InputStream json) {
        return this.parse(json, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContext parse(InputStream json, String charset) {
        Utils.notNull(json, "json input stream can not be null");
        Utils.notNull(charset, "charset can not be null");
        try {
            Object obj = this.configuration.jsonProvider().parse(json, charset);
            JsonContext jsonContext = new JsonContext(obj, this.configuration);
            return jsonContext;
        }
        finally {
            Utils.closeQuietly(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContext parse(File json) throws IOException {
        DocumentContext documentContext;
        Utils.notNull(json, "json file can not be null");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(json);
            documentContext = this.parse(fis);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return documentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DocumentContext parse(URL url) throws IOException {
        Utils.notNull(url, "url can not be null");
        InputStream fis = null;
        try {
            fis = url.openStream();
            DocumentContext documentContext = this.parse(fis);
            return documentContext;
        }
        finally {
            Utils.closeQuietly(fis);
        }
    }
}

