/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.jsonpath.internal.function.sequence;

import java.util.ArrayList;
import java.util.List;
import org.springframework.modulith.runtime.jsonpath.JsonPathException;
import org.springframework.modulith.runtime.jsonpath.internal.EvaluationContext;
import org.springframework.modulith.runtime.jsonpath.internal.PathRef;
import org.springframework.modulith.runtime.jsonpath.internal.function.Parameter;
import org.springframework.modulith.runtime.jsonpath.internal.function.PathFunction;

public abstract class AbstractSequenceAggregation
implements PathFunction {
    protected abstract int targetIndex(EvaluationContext var1, List<Parameter> var2);

    @Override
    public Object invoke(String currentPath, PathRef parent, Object model, EvaluationContext ctx, List<Parameter> parameters) {
        if (ctx.configuration().jsonProvider().isArray(model)) {
            Iterable<?> objects = ctx.configuration().jsonProvider().toIterable(model);
            ArrayList objectList = new ArrayList();
            objects.forEach(objectList::add);
            int targetIndex = this.targetIndex(ctx, parameters);
            if (targetIndex >= 0) {
                return objectList.get(targetIndex);
            }
            int realIndex = objectList.size() + targetIndex;
            if (realIndex > 0) {
                return objectList.get(realIndex);
            }
            throw new JsonPathException("Target index:" + targetIndex + " larger than object count:" + objectList.size());
        }
        throw new JsonPathException("Aggregation function attempted to calculate value using empty array");
    }

    protected int getIndexFromParameters(EvaluationContext ctx, List<Parameter> parameters) {
        List<Number> numbers = Parameter.toList(Number.class, ctx, parameters);
        return numbers.get(0).intValue();
    }
}

