/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.jsonpath.internal.path;

import org.springframework.modulith.runtime.jsonpath.internal.PathRef;
import org.springframework.modulith.runtime.jsonpath.internal.path.ArrayIndexOperation;
import org.springframework.modulith.runtime.jsonpath.internal.path.ArrayPathToken;
import org.springframework.modulith.runtime.jsonpath.internal.path.EvaluationContextImpl;

public class ArrayIndexToken
extends ArrayPathToken {
    private final ArrayIndexOperation arrayIndexOperation;

    ArrayIndexToken(ArrayIndexOperation arrayIndexOperation) {
        this.arrayIndexOperation = arrayIndexOperation;
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (!this.checkArrayModel(currentPath, model, ctx)) {
            return;
        }
        if (this.arrayIndexOperation.isSingleIndexOperation()) {
            this.handleArrayIndex(this.arrayIndexOperation.indexes().get(0), currentPath, model, ctx);
        } else {
            for (Integer index : this.arrayIndexOperation.indexes()) {
                this.handleArrayIndex(index, currentPath, model, ctx);
            }
        }
    }

    @Override
    public String getPathFragment() {
        return this.arrayIndexOperation.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        return this.arrayIndexOperation.isSingleIndexOperation();
    }
}

