/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.event.OAuth2AuthorizedClientRefreshedEvent;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.event.OidcUserRefreshedEvent;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OidcAuthorizedClientRefreshedEventListener
implements ApplicationEventPublisherAware,
ApplicationListener<OAuth2AuthorizedClientRefreshedEvent> {
    private static final String INVALID_ID_TOKEN_ERROR_CODE = "invalid_id_token";
    private static final String INVALID_NONCE_ERROR_CODE = "invalid_nonce";
    private static final String REFRESH_TOKEN_RESPONSE_ERROR_URI = "https://openid.net/specs/openid-connect-core-1_0.html#RefreshTokenResponse";
    private OAuth2UserService<OidcUserRequest, OidcUser> userService = new OidcUserService();
    private JwtDecoderFactory<ClientRegistration> jwtDecoderFactory = new OidcIdTokenDecoderFactory();
    private GrantedAuthoritiesMapper authoritiesMapper = authorities -> authorities;
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private ApplicationEventPublisher applicationEventPublisher;
    private Duration clockSkew = Duration.ofSeconds(60L);

    public void onApplicationEvent(OAuth2AuthorizedClientRefreshedEvent event) {
        OAuth2AuthenticationToken authenticationToken;
        if (this.applicationEventPublisher == null) {
            return;
        }
        OAuth2AccessTokenResponse accessTokenResponse = event.getAccessTokenResponse();
        if (!accessTokenResponse.getAccessToken().getScopes().contains("openid")) {
            return;
        }
        Map additionalParameters = accessTokenResponse.getAdditionalParameters();
        if (!StringUtils.hasText((String)((String)additionalParameters.get("id_token")))) {
            return;
        }
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (!(authentication instanceof OAuth2AuthenticationToken) || ((Object)((Object)(authenticationToken = (OAuth2AuthenticationToken)authentication))).getClass() != OAuth2AuthenticationToken.class) {
            return;
        }
        OAuth2User oAuth2User = authenticationToken.getPrincipal();
        if (!(oAuth2User instanceof OidcUser)) {
            return;
        }
        OidcUser existingOidcUser = (OidcUser)oAuth2User;
        ClientRegistration clientRegistration = event.getAuthorizedClient().getClientRegistration();
        if (!authenticationToken.getAuthorizedClientRegistrationId().equals(clientRegistration.getRegistrationId())) {
            return;
        }
        OidcIdToken idToken = this.createOidcToken(clientRegistration, accessTokenResponse);
        this.validateIdToken(existingOidcUser, idToken);
        OidcUserRequest userRequest = new OidcUserRequest(clientRegistration, accessTokenResponse.getAccessToken(), idToken, additionalParameters);
        OidcUser oidcUser = this.userService.loadUser(userRequest);
        Collection mappedAuthorities = this.authoritiesMapper.mapAuthorities(oidcUser.getAuthorities());
        OAuth2AuthenticationToken authenticationResult = new OAuth2AuthenticationToken((OAuth2User)oidcUser, mappedAuthorities, clientRegistration.getRegistrationId());
        authenticationResult.setDetails(authenticationToken.getDetails());
        OidcUserRefreshedEvent oidcUserRefreshedEvent = new OidcUserRefreshedEvent(accessTokenResponse, existingOidcUser, oidcUser, (Authentication)authenticationResult);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)oidcUserRefreshedEvent);
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setJwtDecoderFactory(JwtDecoderFactory<ClientRegistration> jwtDecoderFactory) {
        Assert.notNull(jwtDecoderFactory, (String)"jwtDecoderFactory cannot be null");
        this.jwtDecoderFactory = jwtDecoderFactory;
    }

    public void setUserService(OAuth2UserService<OidcUserRequest, OidcUser> userService) {
        Assert.notNull(userService, (String)"userService cannot be null");
        this.userService = userService;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        Assert.notNull((Object)authoritiesMapper, (String)"authoritiesMapper cannot be null");
        this.authoritiesMapper = authoritiesMapper;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"applicationEventPublisher cannot be null");
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    private OidcIdToken createOidcToken(ClientRegistration clientRegistration, OAuth2AccessTokenResponse accessTokenResponse) {
        JwtDecoder jwtDecoder = this.jwtDecoderFactory.createDecoder((Object)clientRegistration);
        Jwt jwt = this.getJwt(accessTokenResponse, jwtDecoder);
        return new OidcIdToken(jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt(), jwt.getClaims());
    }

    private Jwt getJwt(OAuth2AccessTokenResponse accessTokenResponse, JwtDecoder jwtDecoder) {
        try {
            Map parameters = accessTokenResponse.getAdditionalParameters();
            return jwtDecoder.decode((String)parameters.get("id_token"));
        }
        catch (JwtException ex) {
            OAuth2Error invalidIdTokenError = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, ex.getMessage(), null);
            throw new OAuth2AuthenticationException(invalidIdTokenError, invalidIdTokenError.toString(), (Throwable)ex);
        }
    }

    private void validateIdToken(OidcUser existingOidcUser, OidcIdToken idToken) {
        this.validateIssuer(existingOidcUser, idToken);
        this.validateSubject(existingOidcUser, idToken);
        this.validateIssuedAt(existingOidcUser, idToken);
        this.validateAudience(existingOidcUser, idToken);
        this.validateAuthenticatedAt(existingOidcUser, idToken);
        this.validateNonce(existingOidcUser, idToken);
    }

    private void validateIssuer(OidcUser existingOidcUser, OidcIdToken idToken) {
        if (!idToken.getIssuer().toString().equals(existingOidcUser.getIdToken().getIssuer().toString())) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Invalid issuer", REFRESH_TOKEN_RESPONSE_ERROR_URI);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
    }

    private void validateSubject(OidcUser existingOidcUser, OidcIdToken idToken) {
        if (!idToken.getSubject().equals(existingOidcUser.getIdToken().getSubject())) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Invalid subject", REFRESH_TOKEN_RESPONSE_ERROR_URI);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
    }

    private void validateIssuedAt(OidcUser existingOidcUser, OidcIdToken idToken) {
        if (!idToken.getIssuedAt().isAfter(existingOidcUser.getIdToken().getIssuedAt().minus(this.clockSkew))) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Invalid issued at time", REFRESH_TOKEN_RESPONSE_ERROR_URI);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
    }

    private void validateAudience(OidcUser existingOidcUser, OidcIdToken idToken) {
        if (!this.isValidAudience(existingOidcUser, idToken)) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Invalid audience", REFRESH_TOKEN_RESPONSE_ERROR_URI);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
    }

    private boolean isValidAudience(OidcUser existingOidcUser, OidcIdToken idToken) {
        List idTokenAudiences = idToken.getAudience();
        HashSet oidcUserAudiences = new HashSet(existingOidcUser.getIdToken().getAudience());
        if (idTokenAudiences.size() != oidcUserAudiences.size()) {
            return false;
        }
        for (String audience : idTokenAudiences) {
            if (oidcUserAudiences.contains(audience)) continue;
            return false;
        }
        return true;
    }

    private void validateAuthenticatedAt(OidcUser existingOidcUser, OidcIdToken idToken) {
        if (idToken.getAuthenticatedAt() == null) {
            return;
        }
        if (!idToken.getAuthenticatedAt().equals(existingOidcUser.getIdToken().getAuthenticatedAt())) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_ID_TOKEN_ERROR_CODE, "Invalid authenticated at time", REFRESH_TOKEN_RESPONSE_ERROR_URI);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
    }

    private void validateNonce(OidcUser existingOidcUser, OidcIdToken idToken) {
        if (!StringUtils.hasText((String)idToken.getNonce())) {
            return;
        }
        if (!idToken.getNonce().equals(existingOidcUser.getIdToken().getNonce())) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_NONCE_ERROR_CODE, "Invalid nonce", REFRESH_TOKEN_RESPONSE_ERROR_URI);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
    }
}

