/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.file.FileInStream;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystem;
import tachyon.examples.Utils;
import tachyon.exception.TachyonException;
import tachyon.thrift.FileInfo;

public class BasicCheckpoint
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final TachyonURI mLocation;
    private final String mFileFolder;
    private final int mNumFiles;

    public BasicCheckpoint(TachyonURI tachyonURI, String fileFolder, int numFiles) {
        this.mLocation = tachyonURI;
        this.mFileFolder = fileFolder;
        this.mNumFiles = numFiles;
    }

    @Override
    public Boolean call() throws Exception {
        TachyonFileSystem tachyonClient = TachyonFileSystem.TachyonFileSystemFactory.get();
        this.writeFile(tachyonClient);
        return this.readFile(tachyonClient);
    }

    private boolean readFile(TachyonFileSystem tachyonClient) throws IOException, TachyonException {
        boolean pass = true;
        for (int i = 0; i < this.mNumFiles; ++i) {
            TachyonURI filePath = new TachyonURI(this.mFileFolder + "/part-" + i);
            LOG.debug("Reading data from {}", (Object)filePath);
            TachyonFile file = tachyonClient.open(filePath);
            FileInStream is = tachyonClient.getInStream(file);
            FileInfo info = tachyonClient.getInfo(file);
            ByteBuffer buf = ByteBuffer.allocate((int)info.getBlockSizeBytes());
            is.read(buf.array());
            buf.order(ByteOrder.nativeOrder());
            for (int k = 0; k < this.mNumFiles; ++k) {
                pass = pass && buf.getInt() == k;
            }
            is.close();
        }
        return pass;
    }

    private void writeFile(TachyonFileSystem tachyonClient) throws IOException, TachyonException {
        for (int i = 0; i < this.mNumFiles; ++i) {
            ByteBuffer buf = ByteBuffer.allocate(80);
            buf.order(ByteOrder.nativeOrder());
            for (int k = 0; k < this.mNumFiles; ++k) {
                buf.putInt(k);
            }
            buf.flip();
            TachyonURI filePath = new TachyonURI(this.mFileFolder + "/part-" + i);
            LOG.debug("Writing data to {}", (Object)filePath);
            FileOutStream os = tachyonClient.getOutStream(filePath);
            os.write(buf.array());
            os.close();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("java -cp " + Constants.TACHYON_JAR + " tachyon.examples.BasicCheckpoint <TachyonMasterAddress> <FileFolder> <Files>");
            System.exit(-1);
        }
        Utils.runExample(new BasicCheckpoint(new TachyonURI(args[0]), args[1], Integer.parseInt(args[2])));
    }
}

