/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.ReadType;
import tachyon.client.WriteType;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystem;
import tachyon.client.file.options.InStreamOptions;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.conf.TachyonConf;
import tachyon.examples.Utils;
import tachyon.exception.FileAlreadyExistsException;
import tachyon.exception.TachyonException;

public final class BasicNonByteBufferOperations
implements Callable<Boolean> {
    private final TachyonURI mMasterLocation;
    private final TachyonURI mFilePath;
    private final ReadType mReadType;
    private final WriteType mWriteType;
    private final boolean mDeleteIfExists;
    private final int mLength;

    public BasicNonByteBufferOperations(TachyonURI masterLocation, TachyonURI filePath, ReadType readType, WriteType writeType, boolean deleteIfExists, int length) {
        this.mMasterLocation = masterLocation;
        this.mFilePath = filePath;
        this.mWriteType = writeType;
        this.mReadType = readType;
        this.mDeleteIfExists = deleteIfExists;
        this.mLength = length;
    }

    @Override
    public Boolean call() throws Exception {
        TachyonConf tachyonConf = ClientContext.getConf();
        tachyonConf.set("tachyon.master.hostname", this.mMasterLocation.getHost());
        tachyonConf.set("tachyon.master.port", Integer.toString(this.mMasterLocation.getPort()));
        ClientContext.reset((TachyonConf)tachyonConf);
        TachyonFileSystem tFS = TachyonFileSystem.TachyonFileSystemFactory.get();
        this.write(tFS, this.mFilePath, this.mWriteType, this.mDeleteIfExists, this.mLength);
        return this.read(tFS, this.mFilePath, this.mReadType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(TachyonFileSystem tachyonFileSystem, TachyonURI filePath, WriteType writeType, boolean deleteIfExists, int length) throws IOException, TachyonException {
        OutStreamOptions clientOptions = new OutStreamOptions.Builder(ClientContext.getConf()).setWriteType(writeType).build();
        FileOutStream fileOutStream = this.getOrCreate(tachyonFileSystem, filePath, deleteIfExists, clientOptions);
        DataOutputStream os = new DataOutputStream((OutputStream)fileOutStream);
        try {
            os.writeInt(length);
            for (int i = 0; i < length; ++i) {
                os.writeInt(i);
            }
        }
        finally {
            os.close();
        }
    }

    private FileOutStream getOrCreate(TachyonFileSystem tachyonFileSystem, TachyonURI filePath, boolean deleteIfExists, OutStreamOptions clientOptions) throws IOException, TachyonException {
        TachyonFile file;
        try {
            file = tachyonFileSystem.open(filePath);
        }
        catch (Exception e) {
            file = null;
        }
        if (file == null) {
            return tachyonFileSystem.getOutStream(filePath, clientOptions);
        }
        if (deleteIfExists) {
            tachyonFileSystem.delete(file);
            return tachyonFileSystem.getOutStream(filePath, clientOptions);
        }
        throw new FileAlreadyExistsException(" file exists but deleteIfExists is false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(TachyonFileSystem tachyonFileSystem, TachyonURI filePath, ReadType readType) throws IOException, TachyonException {
        InStreamOptions clientOptions = new InStreamOptions.Builder(ClientContext.getConf()).setReadType(readType).build();
        TachyonFile file = tachyonFileSystem.open(filePath);
        DataInputStream input = new DataInputStream((InputStream)tachyonFileSystem.getInStream(file, clientOptions));
        boolean passes = true;
        try {
            int length = input.readInt();
            for (int i = 0; i < length; ++i) {
                passes &= input.readInt() == i;
            }
        }
        finally {
            input.close();
        }
        return passes;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2 || args.length > 6) {
            BasicNonByteBufferOperations.usage();
        }
        Utils.runExample(new BasicNonByteBufferOperations(new TachyonURI(args[0]), new TachyonURI(args[1]), Utils.option(args, 2, ReadType.CACHE), Utils.option(args, 3, WriteType.CACHE_THROUGH), Utils.option(args, 4, true), Utils.option(args, 5, 20)));
    }

    private static void usage() {
        System.out.println("java -cp " + Constants.TACHYON_JAR + " " + BasicNonByteBufferOperations.class.getName() + " <master address> <file path> " + " <ReadType (CACHE_PROMOTE | CACHE | NO_CACHE)> <WriteType (MUST_CACHE | CACHE_THROUGH" + " | THROUGH)> <delete file> <number of files>");
        System.exit(-1);
    }
}

