/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.ReadType;
import tachyon.client.WriteType;
import tachyon.client.file.FileInStream;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystem;
import tachyon.client.file.options.CreateOptions;
import tachyon.client.file.options.InStreamOptions;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.conf.TachyonConf;
import tachyon.examples.Utils;
import tachyon.exception.TachyonException;
import tachyon.util.CommonUtils;
import tachyon.util.FormatUtils;

public class BasicOperations
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final TachyonURI mMasterLocation;
    private final TachyonURI mFilePath;
    private final InStreamOptions mReadOptions;
    private final OutStreamOptions mWriteOptions;
    private final int mNumbers = 20;

    public BasicOperations(TachyonURI masterLocation, TachyonURI filePath, ReadType readType, WriteType writeType) {
        this.mMasterLocation = masterLocation;
        this.mFilePath = filePath;
        this.mReadOptions = new InStreamOptions.Builder(ClientContext.getConf()).setReadType(readType).build();
        this.mWriteOptions = new OutStreamOptions.Builder(ClientContext.getConf()).setWriteType(writeType).build();
    }

    @Override
    public Boolean call() throws Exception {
        TachyonConf tachyonConf = ClientContext.getConf();
        tachyonConf.set("tachyon.master.hostname", this.mMasterLocation.getHost());
        tachyonConf.set("tachyon.master.port", Integer.toString(this.mMasterLocation.getPort()));
        ClientContext.reset((TachyonConf)tachyonConf);
        TachyonFileSystem tFS = TachyonFileSystem.TachyonFileSystemFactory.get();
        long fileId = this.createFile(tFS);
        this.writeFile(fileId);
        return this.readFile(tFS, fileId);
    }

    private long createFile(TachyonFileSystem tachyonFileSystem) throws IOException, TachyonException {
        LOG.debug("Creating file...");
        long startTimeMs = CommonUtils.getCurrentMs();
        CreateOptions createOptions = new CreateOptions.Builder(ClientContext.getConf()).setBlockSizeBytes(this.mWriteOptions.getBlockSizeBytes()).setRecursive(true).setTTL(this.mWriteOptions.getTTL()).setUnderStorageType(this.mWriteOptions.getUnderStorageType()).build();
        TachyonFile tFile = tachyonFileSystem.create(this.mFilePath, createOptions);
        long fileId = tFile.getFileId();
        LOG.info(FormatUtils.formatTimeTakenMs((long)startTimeMs, (String)("createFile with fileId " + fileId)));
        return fileId;
    }

    private void writeFile(long fileId) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(80);
        buf.order(ByteOrder.nativeOrder());
        for (int k = 0; k < 20; ++k) {
            buf.putInt(k);
        }
        buf.flip();
        LOG.debug("Writing data...");
        buf.flip();
        long startTimeMs = CommonUtils.getCurrentMs();
        FileOutStream os = new FileOutStream(fileId, this.mWriteOptions);
        os.write(buf.array());
        os.close();
        LOG.info(FormatUtils.formatTimeTakenMs((long)startTimeMs, (String)("writeFile to file " + this.mFilePath)));
    }

    private boolean readFile(TachyonFileSystem tachyonFileSystem, long fileId) throws IOException, TachyonException {
        boolean pass = true;
        LOG.debug("Reading data...");
        TachyonFile file = new TachyonFile(fileId);
        long startTimeMs = CommonUtils.getCurrentMs();
        FileInStream is = tachyonFileSystem.getInStream(file, this.mReadOptions);
        ByteBuffer buf = ByteBuffer.allocate((int)is.remaining());
        is.read(buf.array());
        buf.order(ByteOrder.nativeOrder());
        for (int k = 0; k < 20; ++k) {
            pass = pass && buf.getInt() == k;
        }
        is.close();
        LOG.info(FormatUtils.formatTimeTakenMs((long)startTimeMs, (String)("readFile file " + this.mFilePath)));
        return pass;
    }

    public static void main(String[] args) throws IllegalArgumentException {
        if (args.length != 4) {
            System.out.println("java -cp " + Constants.TACHYON_JAR + " " + BasicOperations.class.getName() + " <ReadType (CACHE_PROMOTE | CACHE | NO_CACHE)> <WriteType (MUST_CACHE | CACHE_THROUGH" + " | THROUGH)>");
            System.exit(-1);
        }
        Utils.runExample(new BasicOperations(new TachyonURI(args[0]), new TachyonURI(args[1]), ReadType.valueOf((String)args[2]), WriteType.valueOf((String)args[3])));
    }
}

