/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.ReadType;
import tachyon.client.TachyonStorageType;
import tachyon.client.UnderStorageType;
import tachyon.client.WriteType;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    private Utils() {
    }

    public static void printPassInfo(boolean pass) {
        if (pass) {
            System.out.println("\u001b[32mPassed the test!\u001b[0m");
        } else {
            System.out.println("\u001b[31mFailed the test!\u001b[0m");
        }
    }

    public static String option(String[] args, int index, String defaultValue) {
        if (index < args.length && index >= 0) {
            return args[index];
        }
        return defaultValue;
    }

    public static boolean option(String[] args, int index, boolean defaultValue) {
        if (index < args.length && index >= 0) {
            return Boolean.parseBoolean(args[index]);
        }
        return defaultValue;
    }

    public static int option(String[] args, int index, int defaultValue) {
        if (index < args.length && index >= 0) {
            try {
                return Integer.parseInt(args[index]);
            }
            catch (NumberFormatException e) {
                System.err.println("Unable to parse int;" + e.getMessage());
                System.err.println("Defaulting to " + defaultValue);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static ReadType option(String[] args, int index, ReadType defaultValue) {
        if (index < args.length && index >= 0) {
            try {
                return ReadType.valueOf((String)args[index]);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unable to parse ReadType;" + e.getMessage());
                System.err.println("Defaulting to " + defaultValue);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static TachyonStorageType option(String[] args, int index, TachyonStorageType defaultValue) {
        if (index < args.length && index >= 0) {
            try {
                return TachyonStorageType.valueOf((String)args[index]);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unable to parse TachyonStorageType;" + e.getMessage());
                System.err.println("Defaulting to " + defaultValue);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static UnderStorageType option(String[] args, int index, UnderStorageType defaultValue) {
        if (index < args.length && index >= 0) {
            try {
                return UnderStorageType.valueOf((String)args[index]);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unable to parse UnderStorageType;" + e.getMessage());
                System.err.println("Defaulting to " + defaultValue);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static WriteType option(String[] args, int index, WriteType defaultValue) {
        if (index < args.length && index >= 0) {
            try {
                return WriteType.valueOf((String)args[index]);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unable to parse WriteType;" + e.getMessage());
                System.err.println("Defaulting to " + defaultValue);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static void runExample(Callable<Boolean> example) {
        boolean result;
        try {
            result = example.call();
        }
        catch (Exception e) {
            LOG.error("Exception running test: " + example, (Throwable)e);
            result = false;
        }
        Utils.printPassInfo(result);
        System.exit(result ? 0 : 1);
    }
}

