/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.dialect;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dialect.AbstractDialect;
import org.thymeleaf.dialect.IExpressionEnhancingDialect;
import org.thymeleaf.extras.springsecurity3.auth.AuthUtils;
import org.thymeleaf.extras.springsecurity3.auth.Authorization;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthenticationAttrProcessor;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthorizeAclAttrProcessor;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthorizeAttrProcessor;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthorizeUrlAttrProcessor;
import org.thymeleaf.processor.IProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityDialect
extends AbstractDialect
implements IExpressionEnhancingDialect {
    public static final String DEFAULT_PREFIX = "sec";
    public static final String AUTHENTICATION_EXPRESSION_OBJECT_NAME = "authentication";
    public static final String AUTHORIZATION_EXPRESSION_OBJECT_NAME = "authorization";

    public String getPrefix() {
        return DEFAULT_PREFIX;
    }

    public boolean isLenient() {
        return false;
    }

    public Set<IProcessor> getProcessors() {
        LinkedHashSet<IProcessor> processors = new LinkedHashSet<IProcessor>();
        processors.add((IProcessor)new AuthenticationAttrProcessor());
        processors.add((IProcessor)new AuthorizeAttrProcessor());
        processors.add((IProcessor)new AuthorizeAttrProcessor("authorize-expr"));
        processors.add((IProcessor)new AuthorizeUrlAttrProcessor());
        processors.add((IProcessor)new AuthorizeAclAttrProcessor());
        return processors;
    }

    public Map<String, Object> getAdditionalExpressionObjects(IProcessingContext processingContext) {
        IContext context = processingContext.getContext();
        IWebContext webContext = context instanceof IWebContext ? (IWebContext)context : null;
        HashMap<String, Object> objects = new HashMap<String, Object>(3, 1.0f);
        if (webContext != null) {
            HttpServletRequest request = webContext.getHttpServletRequest();
            HttpServletResponse response = webContext.getHttpServletResponse();
            ServletContext servletContext = webContext.getServletContext();
            if (request != null && response != null && servletContext != null) {
                Authentication authentication = AuthUtils.getAuthenticationObject();
                Authorization authorization = new Authorization(processingContext, authentication, request, response, servletContext);
                objects.put(AUTHENTICATION_EXPRESSION_OBJECT_NAME, authentication);
                objects.put(AUTHORIZATION_EXPRESSION_OBJECT_NAME, authorization);
            }
        }
        return objects;
    }
}

