/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.dialect.processor;

import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.extras.springsecurity3.auth.AclAuthUtils;
import org.thymeleaf.extras.springsecurity3.auth.AuthUtils;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.TextLiteralExpression;

public class AuthorizeAclAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    public static final int ATTR_PRECEDENCE = 300;
    public static final String ATTR_NAME = "authorize-acl";
    private static final String VALUE_SEPARATOR = "::";

    public AuthorizeAclAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 300;
    }

    protected boolean isVisible(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue == null || attributeValue.trim().equals("")) {
            return false;
        }
        attributeValue = attributeValue.trim();
        IContext context = arguments.getContext();
        if (!(context instanceof IWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a web context (implementation of " + IWebContext.class.getName() + ". Spring Security integration can only be used in " + "web environements.");
        }
        IWebContext webContext = (IWebContext)context;
        ServletContext servletContext = webContext.getServletContext();
        Authentication authentication = AuthUtils.getAuthenticationObject();
        if (authentication == null) {
            return false;
        }
        ApplicationContext applicationContext = AuthUtils.getContext(servletContext);
        Configuration configuration = arguments.getConfiguration();
        int separatorPos = attributeValue.lastIndexOf(VALUE_SEPARATOR);
        if (separatorPos == -1) {
            throw new TemplateProcessingException("Could not parse \"" + attributeValue + "\" as an access control list " + "expression. Syntax should be \"[domain object expression] :: [permissions]\"");
        }
        String domainObjectExpression = attributeValue.substring(0, separatorPos).trim();
        String permissionsExpression = attributeValue.substring(separatorPos + 2).trim();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((Configuration)configuration);
        IStandardExpression domainObjectExpr = AuthorizeAclAttrProcessor.getExpressionDefaultToLiteral(expressionParser, configuration, (IProcessingContext)arguments, domainObjectExpression);
        IStandardExpression permissionsExpr = AuthorizeAclAttrProcessor.getExpressionDefaultToLiteral(expressionParser, configuration, (IProcessingContext)arguments, permissionsExpression);
        Object domainObject = domainObjectExpr.execute(configuration, (IProcessingContext)arguments);
        Object permissionsObject = permissionsExpr.execute(configuration, (IProcessingContext)arguments);
        String permissionsStr = permissionsObject == null ? null : permissionsObject.toString();
        return AclAuthUtils.authorizeUsingAccessControlList(domainObject, applicationContext, permissionsStr, authentication, servletContext);
    }

    protected static IStandardExpression getExpressionDefaultToLiteral(IStandardExpressionParser expressionParser, Configuration configuration, IProcessingContext processingContext, String input) {
        IStandardExpression expression = expressionParser.parseExpression(configuration, processingContext, input);
        if (expression == null) {
            return new TextLiteralExpression(input);
        }
        return expression;
    }
}

