/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.activation;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;
import org.togglz.servlet.util.HttpServletRequestHolder;

public class QueryParameterActivationStrategy
implements ActivationStrategy {
    private static final Log log = LogFactory.getLog(QueryParameterActivationStrategy.class);
    public static final String PARAM_URL_PARAMS = "params";
    private static final Pattern SPLIT_ON_COMMA = Pattern.compile("\\s*,\\s*");
    private static final Pattern SPLIT_ON_EQUALS = Pattern.compile("\\s*=\\s*");

    public String getId() {
        return "query-parameter";
    }

    public String getName() {
        return "Query Parameter";
    }

    public boolean isActive(FeatureState featureState, FeatureUser user) {
        HttpServletRequest request = HttpServletRequestHolder.get();
        if (request == null) {
            return false;
        }
        String triggerParamsString = featureState.getParameter(PARAM_URL_PARAMS);
        if (Strings.isBlank((String)triggerParamsString)) {
            return false;
        }
        String[] triggerParams = SPLIT_ON_COMMA.split(triggerParamsString.trim());
        HashMap<String, String[]> actualParams = new HashMap<String, String[]>();
        actualParams.putAll(request.getParameterMap());
        String referer = request.getHeader("referer");
        if (referer != null) {
            for (Map.Entry<String, List<String>> entry : this.getRefererParameters(actualParams, referer).entrySet()) {
                actualParams.put(entry.getKey(), entry.getValue().toArray(new String[entry.getValue().size()]));
            }
        }
        return this.isTriggerParamPresent(actualParams, triggerParams);
    }

    private Map<String, List<String>> getRefererParameters(Map<String, String[]> requestParams, String referer) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            for (Map.Entry<String, String> pair : this.getQueryParams(new URI(referer))) {
                if (requestParams.containsKey(pair.getKey())) continue;
                if (result.containsKey(pair.getKey())) {
                    List values = (List)result.get(pair.getKey());
                    values.add(pair.getValue());
                    result.put(pair.getKey(), values);
                    continue;
                }
                result.put(pair.getKey(), new ArrayList<String>(Collections.singletonList(pair.getValue())));
            }
        }
        catch (URISyntaxException e) {
            log.warn("Ignoring invalid referer: " + referer);
        }
        return result;
    }

    private List<Map.Entry<String, String>> getQueryParams(URI uri) {
        try {
            ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
            for (String pair : uri.getQuery().split("&")) {
                int idx = pair.indexOf("=");
                String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                result.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isTriggerParamPresent(Map<String, String[]> actualParams, String[] triggerParams) {
        for (String triggerParam : triggerParams) {
            String[] paramData = SPLIT_ON_EQUALS.split(triggerParam, 2);
            if (!actualParams.containsKey(paramData[0])) continue;
            if (paramData.length == 1) {
                return true;
            }
            String[] paramValues = actualParams.get(paramData[0]);
            if (paramValues == null) continue;
            for (String paramValue : paramValues) {
                if (!Objects.equals(paramData[1], paramValue)) continue;
                return true;
            }
        }
        return false;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create((String)PARAM_URL_PARAMS).label("Query Parameters").description("A comma-separated list of Name[=Value] pairs for which the feature should be active. Please choose unique names for your parameter(s). If no value is specified, simply having the parameter present will activate the toggle.\nImportant Note: Use unique parameter key/value pairs to avoid accidental activation.")};
    }
}

