/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency.asm;

import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependenciesClassAdapter
extends RemappingClassAdapter {
    private static final EmptyVisitor ev = new EmptyVisitor();

    public DependenciesClassAdapter() {
        super((ClassVisitor)ev, (Remapper)new CollectingRemapper());
    }

    public Set<String> getDependencies() {
        return ((CollectingRemapper)this.remapper).classes;
    }

    static class EmptyVisitor
    extends ClassVisitor {
        private static final AnnotationVisitor av = new AnnotationVisitor(327680){

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return this;
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }
        };
        private static final MethodVisitor mv = new MethodVisitor(327680){

            public AnnotationVisitor visitAnnotationDefault() {
                return av;
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return av;
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                return av;
            }
        };
        private static final FieldVisitor fieldVisitor = new FieldVisitor(327680){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return av;
            }
        };

        public EmptyVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return av;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return fieldVisitor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return mv;
        }
    }

    private static class CollectingRemapper
    extends Remapper {
        final Set<String> classes = new HashSet<String>();

        private CollectingRemapper() {
        }

        public String map(String pClassName) {
            this.classes.add(pClassName.replace('/', '.'));
            return pClassName;
        }
    }
}

