/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.dbcp.ViburDBCPMonitoringMBean;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.util.ViburUtils;
import org.vibur.objectpool.PoolService;
import org.vibur.objectpool.util.TakenListener;

public class ViburDBCPMonitoring
implements ViburDBCPMonitoringMBean {
    private final ViburDBCPConfig config;

    public ViburDBCPMonitoring(ViburDBCPConfig config) throws ViburDBCPException {
        this.config = config;
    }

    @Override
    public String getJdbcUrl() {
        return this.config.getJdbcUrl();
    }

    @Override
    public String getDriverClassName() {
        return this.config.getDriverClassName();
    }

    @Override
    public int getConnectionIdleLimitInSeconds() {
        return this.config.getConnectionIdleLimitInSeconds();
    }

    @Override
    public void setConnectionIdleLimitInSeconds(int connectionIdleLimitInSeconds) {
        this.config.setConnectionIdleLimitInSeconds(connectionIdleLimitInSeconds);
    }

    @Override
    public int getValidateTimeoutInSeconds() {
        return this.config.getValidateTimeoutInSeconds();
    }

    @Override
    public void setValidateTimeoutInSeconds(int validateTimeoutInSeconds) {
        this.config.setValidateTimeoutInSeconds(validateTimeoutInSeconds);
    }

    @Override
    public String getTestConnectionQuery() {
        return this.config.getTestConnectionQuery();
    }

    @Override
    public void setTestConnectionQuery(String testConnectionQuery) {
        this.config.setTestConnectionQuery(testConnectionQuery);
    }

    @Override
    public String getInitSQL() {
        return this.config.getInitSQL();
    }

    @Override
    public void setInitSQL(String initSQL) {
        this.config.setInitSQL(initSQL);
    }

    @Override
    public int getPoolInitialSize() {
        return this.config.getPoolInitialSize();
    }

    @Override
    public int getPoolMaxSize() {
        return this.config.getPoolMaxSize();
    }

    @Override
    public int getPoolTaken() {
        return this.config.getPool().taken();
    }

    @Override
    public int getPoolRemainingCreated() {
        return this.config.getPool().remainingCreated();
    }

    @Override
    public boolean isPoolFair() {
        return this.config.isPoolFair();
    }

    @Override
    public boolean isPoolEnableConnectionTracking() {
        return this.config.isPoolEnableConnectionTracking();
    }

    @Override
    public int getReducerTimeIntervalInSeconds() {
        return this.config.getReducerTimeIntervalInSeconds();
    }

    @Override
    public int getReducerSamples() {
        return this.config.getReducerSamples();
    }

    @Override
    public long getConnectionTimeoutInMs() {
        return this.config.getConnectionTimeoutInMs();
    }

    @Override
    public void setConnectionTimeoutInMs(long connectionTimeoutInMs) {
        this.config.setConnectionTimeoutInMs(connectionTimeoutInMs);
    }

    @Override
    public int getLoginTimeoutInSeconds() {
        return this.config.getLoginTimeoutInSeconds();
    }

    @Override
    public void setLoginTimeoutInSeconds(int loginTimeoutInSeconds) {
        this.config.setLoginTimeoutInSeconds(loginTimeoutInSeconds);
    }

    @Override
    public long getAcquireRetryDelayInMs() {
        return this.config.getAcquireRetryDelayInMs();
    }

    @Override
    public void setAcquireRetryDelayInMs(long acquireRetryDelayInMs) {
        this.config.setAcquireRetryDelayInMs(acquireRetryDelayInMs);
    }

    @Override
    public int getAcquireRetryAttempts() {
        return this.config.getAcquireRetryAttempts();
    }

    @Override
    public void setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.config.setAcquireRetryAttempts(acquireRetryAttempts);
    }

    @Override
    public int getStatementCacheMaxSize() {
        return this.config.getStatementCacheMaxSize();
    }

    @Override
    public long getLogConnectionLongerThanMs() {
        return this.config.getLogConnectionLongerThanMs();
    }

    @Override
    public void setLogConnectionLongerThanMs(long logConnectionLongerThanMs) {
        this.config.setLogConnectionLongerThanMs(logConnectionLongerThanMs);
    }

    @Override
    public boolean isLogStackTraceForLongConnection() {
        return this.config.isLogStackTraceForLongConnection();
    }

    @Override
    public void setLogStackTraceForLongConnection(boolean logStackTraceForLongConnection) {
        this.config.setLogStackTraceForLongConnection(logStackTraceForLongConnection);
    }

    @Override
    public long getLogQueryExecutionLongerThanMs() {
        return this.config.getLogQueryExecutionLongerThanMs();
    }

    @Override
    public void setLogQueryExecutionLongerThanMs(long logQueryExecutionLongerThanMs) {
        this.config.setLogQueryExecutionLongerThanMs(logQueryExecutionLongerThanMs);
    }

    @Override
    public boolean isLogStackTraceForLongQueryExecution() {
        return this.config.isLogStackTraceForLongQueryExecution();
    }

    @Override
    public void setLogStackTraceForLongQueryExecution(boolean logStackTraceForLongQueryExecution) {
        this.config.setLogStackTraceForLongQueryExecution(logStackTraceForLongQueryExecution);
    }

    @Override
    public long getLogLargeResultSet() {
        return this.config.getLogLargeResultSet();
    }

    @Override
    public void setLogLargeResultSet(long logLargeResultSet) {
        this.config.setLogLargeResultSet(logLargeResultSet);
    }

    @Override
    public boolean isLogStackTraceForLargeResultSet() {
        return this.config.isLogStackTraceForLargeResultSet();
    }

    @Override
    public void setLogStackTraceForLargeResultSet(boolean logStackTraceForLargeResultSet) {
        this.config.setLogStackTraceForLargeResultSet(logStackTraceForLargeResultSet);
    }

    @Override
    public boolean isResetDefaultsAfterUse() {
        return this.config.isResetDefaultsAfterUse();
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.config.getDefaultAutoCommit();
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.config.getDefaultReadOnly();
    }

    @Override
    public String getDefaultTransactionIsolation() {
        return this.config.getDefaultTransactionIsolation();
    }

    @Override
    public String getDefaultCatalog() {
        return this.config.getDefaultCatalog();
    }

    @Override
    public boolean isClearSQLWarnings() {
        return this.config.isClearSQLWarnings();
    }

    @Override
    public String showTakenConnections() {
        if (!this.config.isPoolEnableConnectionTracking()) {
            return "poolEnableConnectionTracking is disabled.";
        }
        PoolService poolService = (PoolService)this.config.getPool();
        List connHolders = ((TakenListener)poolService.listener()).getTaken();
        Collections.sort(connHolders, new Comparator<ConnHolder>(){

            @Override
            public int compare(ConnHolder h1, ConnHolder h2) {
                long diff = h2.getTakenTime() - h1.getTakenTime();
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
        });
        StringBuilder builder = new StringBuilder(4096);
        for (ConnHolder connHolder : connHolders) {
            builder.append(connHolder.value()).append(", taken at: ").append(new Date(connHolder.getTakenTime())).append(", millis = ").append(connHolder.getTakenTime()).append('\n').append(ViburUtils.getStackTraceAsString(connHolder.getStackTrace())).append('\n');
        }
        return builder.toString();
    }
}

