/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.cache.StatementHolder;
import org.vibur.dbcp.pool.ConnHolder;
import org.vibur.dbcp.pool.PoolOperations;
import org.vibur.dbcp.proxy.ChildObjectInvocationHandler;
import org.vibur.dbcp.proxy.ConnectionInvocationHandler;
import org.vibur.dbcp.proxy.ExceptionCollector;
import org.vibur.dbcp.proxy.ResultSetInvocationHandler;
import org.vibur.dbcp.proxy.StatementInvocationHandler;

public final class Proxy {
    private static final Constructor<?> connectionCtor;
    private static final Constructor<?> statementCtor;
    private static final Constructor<?> pStatementCtor;
    private static final Constructor<?> cStatementCtor;
    private static final Constructor<?> metadataCtor;
    private static final Constructor<?> resultSetCtor;
    private static final ClassLoader classLoader;

    private Proxy() {
    }

    public static Connection newProxyConnection(ConnHolder conn, PoolOperations poolOperations, ViburDBCPConfig config) {
        ConnectionInvocationHandler handler = new ConnectionInvocationHandler(conn, poolOperations, config);
        return (Connection)Proxy.newProxy(connectionCtor, handler);
    }

    static Statement newProxyStatement(StatementHolder statement, Connection connProxy, ViburDBCPConfig config, ExceptionCollector exceptionCollector) {
        StatementInvocationHandler handler = new StatementInvocationHandler(statement, null, connProxy, config, exceptionCollector);
        return (Statement)Proxy.newProxy(statementCtor, handler);
    }

    static PreparedStatement newProxyPreparedStatement(StatementHolder pStatement, Connection connProxy, ViburDBCPConfig config, ExceptionCollector exceptionCollector) {
        StatementInvocationHandler handler = new StatementInvocationHandler(pStatement, config.getStatementCache(), connProxy, config, exceptionCollector);
        return (PreparedStatement)Proxy.newProxy(pStatementCtor, handler);
    }

    static CallableStatement newProxyCallableStatement(StatementHolder cStatement, Connection connProxy, ViburDBCPConfig config, ExceptionCollector exceptionCollector) {
        StatementInvocationHandler handler = new StatementInvocationHandler(cStatement, config.getStatementCache(), connProxy, config, exceptionCollector);
        return (CallableStatement)Proxy.newProxy(cStatementCtor, handler);
    }

    static DatabaseMetaData newProxyDatabaseMetaData(DatabaseMetaData rawMetaData, Connection connProxy, ViburDBCPConfig config, ExceptionCollector exceptionCollector) {
        ChildObjectInvocationHandler<Connection, DatabaseMetaData> handler = new ChildObjectInvocationHandler<Connection, DatabaseMetaData>(rawMetaData, connProxy, "getConnection", config, exceptionCollector);
        return (DatabaseMetaData)Proxy.newProxy(metadataCtor, handler);
    }

    static ResultSet newProxyResultSet(ResultSet rawResultSet, Statement statementProxy, Object[] executeMethodArgs, List<Object[]> queryParams, ViburDBCPConfig config, ExceptionCollector exceptionCollector) {
        ResultSetInvocationHandler handler = new ResultSetInvocationHandler(rawResultSet, statementProxy, executeMethodArgs, queryParams, config, exceptionCollector);
        return (ResultSet)Proxy.newProxy(resultSetCtor, handler);
    }

    private static Object newProxy(Constructor<?> proxyCtor, InvocationHandler invocationHandler) {
        try {
            return proxyCtor.newInstance(invocationHandler);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    static {
        classLoader = Thread.currentThread().getContextClassLoader();
        try {
            connectionCtor = java.lang.reflect.Proxy.getProxyClass(classLoader, Connection.class).getConstructor(InvocationHandler.class);
            statementCtor = java.lang.reflect.Proxy.getProxyClass(classLoader, Statement.class).getConstructor(InvocationHandler.class);
            pStatementCtor = java.lang.reflect.Proxy.getProxyClass(classLoader, PreparedStatement.class).getConstructor(InvocationHandler.class);
            cStatementCtor = java.lang.reflect.Proxy.getProxyClass(classLoader, CallableStatement.class).getConstructor(InvocationHandler.class);
            metadataCtor = java.lang.reflect.Proxy.getProxyClass(classLoader, DatabaseMetaData.class).getConstructor(InvocationHandler.class);
            resultSetCtor = java.lang.reflect.Proxy.getProxyClass(classLoader, ResultSet.class).getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }
}

