/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburDBCPMonitoringMBean;

public final class JmxUtils {
    private static final Logger logger = LoggerFactory.getLogger(JmxUtils.class);

    private JmxUtils() {
    }

    public static void registerMBean(ViburDBCPMonitoringMBean mBean, String jmxName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(jmxName);
            if (!mbs.isRegistered(objectName)) {
                mbs.registerMBean(mBean, objectName);
            } else {
                logger.warn(jmxName + " is already registered.");
            }
        }
        catch (JMException e) {
            logger.warn("Unable to register mBean {}", (Object)jmxName, (Object)e);
        }
    }

    public static void unregisterMBean(String jmxName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(jmxName);
            if (mbs.isRegistered(objectName)) {
                mbs.unregisterMBean(objectName);
            } else {
                logger.warn(jmxName + " is not registered.");
            }
        }
        catch (JMException e) {
            logger.warn("Unable to unregister mBean {}", (Object)jmxName, (Object)e);
        }
    }
}

