/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburDBCPConfig;
import org.vibur.dbcp.ViburDBCPException;
import org.vibur.objectpool.BasePool;

public final class ViburUtils {
    private static final Logger logger = LoggerFactory.getLogger(ViburUtils.class);

    private ViburUtils() {
    }

    public static String getPoolName(ViburDBCPConfig config) {
        BasePool pool = config.getPool();
        return String.format("%s (%d/%d)", config.getName(), pool.taken(), pool.remainingCreated());
    }

    public static String getStackTraceAsString(StackTraceElement[] stackTrace) {
        int i;
        for (i = 0; i < stackTrace.length && stackTrace[i].getClassName().startsWith("org.vibur.dbcp") && !stackTrace[i].getClassName().endsWith("Test"); ++i) {
        }
        StringBuilder builder = new StringBuilder(4096);
        while (i < stackTrace.length) {
            builder.append("  at ").append(stackTrace[i]).append('\n');
            ++i;
        }
        return builder.toString();
    }

    public static Connection unwrapSQLException(ViburDBCPException e) throws SQLException {
        Throwable cause = e.getCause();
        if (cause instanceof SQLException) {
            throw (SQLException)cause;
        }
        logger.error("Unexpected exception cause", (Throwable)e);
        throw e;
    }
}

