/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.wildfly.galleon.plugin.config.generator.ServerBridge;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;

public abstract class BaseConfigGenerator {
    protected static final byte INITIAL = 0;
    protected static final byte START_STANDALONE = 1;
    protected static final byte START_HC = 2;
    protected static final byte LOOKING_FOR_ARGS = 4;
    protected static final byte EMBEDDED_STARTED = 8;
    protected static final String BATCH = "batch";
    protected static final String STOP = "stop";
    protected static final String RUN_BATCH = "run-batch";
    protected boolean hc;
    protected String[] args;
    protected Long bootTimeout = null;
    protected Object embeddedProcess;
    protected Object mcc;
    protected Object composite;
    protected String jbossHome;
    protected boolean forkEmbedded;
    protected String resetSysProps;
    protected String stabilityLevel;
    protected Path script;
    protected PrintWriter scriptWriter;
    protected StringBuilder scriptBuf;
    private static ServerBridge serverBridge;

    public static void initializeEmbedded(ClassLoader loader) throws ConfigGeneratorException {
        serverBridge = ServerBridge.get(loader);
    }

    protected void handle(String json) throws ConfigGeneratorException {
        if (this.forkEmbedded) {
            this.scriptWriter.write(json);
            this.scriptWriter.println();
        } else if (this.composite != null) {
            serverBridge.dmr_steps_add(this.composite, json);
        } else {
            this.doHandle(json);
        }
    }

    protected void doHandle(String json) throws ConfigGeneratorException {
        Object op = serverBridge.dmr_fromJSON(json);
        this.doHandle(op);
    }

    private void doHandle(Object op) throws ConfigGeneratorException {
        Object response = serverBridge.mcc_execute(this.mcc, op);
        if (serverBridge.dmr_isSuccessful(response).booleanValue()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to");
        if (this.hc) {
            String domainConfig = null;
            boolean emptyDomain = false;
            String hostConfig = null;
            boolean emptyHost = false;
            int i = 0;
            while (i < this.args.length) {
                String arg;
                if ((arg = this.args[i++]).startsWith("--domain-config")) {
                    if (arg.length() == "--domain-config".length()) {
                        domainConfig = this.args[i++];
                        continue;
                    }
                    domainConfig = arg.substring("--domain-config".length() + 1);
                    continue;
                }
                if (arg.startsWith("--host-config")) {
                    if (arg.length() == "--host-config".length()) {
                        hostConfig = this.args[i++];
                        continue;
                    }
                    hostConfig = arg.substring("--host-config".length() + 1);
                    continue;
                }
                if (arg.equals("--empty-host-config")) {
                    emptyHost = true;
                    continue;
                }
                if (!arg.equals("--empty-domain-config")) continue;
                emptyDomain = true;
            }
            if (emptyDomain) {
                buf.append(" generate ").append(domainConfig);
                if (emptyHost && hostConfig != null) {
                    buf.append(" and ").append(hostConfig);
                }
            } else if (emptyHost) {
                buf.append(" generate ").append(hostConfig);
            } else {
                buf.append(" execute script");
            }
        } else {
            String serverConfig = null;
            boolean emptyConfig = false;
            int i = 0;
            while (i < this.args.length) {
                String arg;
                if ((arg = this.args[i++]).equals("--server-config")) {
                    if (arg.length() == "--server-config".length()) {
                        serverConfig = this.args[i++];
                        continue;
                    }
                    serverConfig = arg.substring("--server-config".length() + 1);
                    continue;
                }
                if (!arg.equals("--internal-empty-config")) continue;
                emptyConfig = true;
            }
            if (emptyConfig) {
                buf.append(" generate ").append(serverConfig);
            } else {
                buf.append(" execute script");
            }
        }
        buf.append(" on ").append(op).append(": ").append(serverBridge.dmr_getFailureDescription(response));
        throw new ConfigGeneratorException(buf.toString());
    }

    void startBatch() {
        if (this.forkEmbedded) {
            this.writeScript(BATCH);
        } else {
            try {
                this.composite = serverBridge.dmr_createCompositeOperation();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    void endBatch() throws ConfigGeneratorException {
        if (this.forkEmbedded) {
            this.writeScript(RUN_BATCH);
        } else {
            this.doHandle(this.composite);
            this.composite = null;
        }
    }

    protected void doStartHc(String ... args) throws ConfigGeneratorException {
        this.args = args;
        this.hc = true;
        this.embeddedProcess = serverBridge.embed_createHostController(this.jbossHome, args);
        serverBridge.embed_start(this.embeddedProcess);
        this.mcc = serverBridge.embed_getModelControllerClient(this.embeddedProcess);
        this.waitForHc(this.embeddedProcess);
    }

    protected void waitForHc(Object embeddedProcess) throws ConfigGeneratorException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            String status;
            long expired;
            long l = expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            while ((status = serverBridge.embed_getProcessState(embeddedProcess)) == null || "starting".equals(status)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ConfigGeneratorException("Interrupted while waiting for embedded server to start");
                }
                if (System.nanoTime() < expired) continue;
            }
            if (status == null || "starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ConfigGeneratorException("Embedded host controller did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }

    protected void doStartServer(String ... args) throws ConfigGeneratorException {
        this.args = args;
        this.hc = false;
        try {
            this.embeddedProcess = serverBridge.embed_createStandalone(this.jbossHome, args);
            serverBridge.embed_start(this.embeddedProcess);
            this.mcc = serverBridge.embed_getModelControllerClient(this.embeddedProcess);
        }
        catch (Exception e) {
            throw new ConfigGeneratorException("Failed to start embedded server", (Throwable)e);
        }
        this.waitForServer();
    }

    protected void doStopEmbedded() throws ConfigGeneratorException {
        if (this.mcc != null) {
            try {
                serverBridge.mcc_close(this.mcc);
            }
            catch (Exception e) {
                throw new ConfigGeneratorException("Failed to close ModelControllerClient", (Throwable)e);
            }
            this.mcc = null;
        }
        if (this.embeddedProcess != null) {
            try {
                serverBridge.embed_stop(this.embeddedProcess);
            }
            catch (Exception e) {
                throw new ConfigGeneratorException("Failed to close ModelControllerClient", (Throwable)e);
            }
            this.embeddedProcess = null;
        }
    }

    protected void waitForServer() throws ConfigGeneratorException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            Object getStateOp;
            long expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            String status = "starting";
            try {
                getStateOp = serverBridge.dmr_newInstance();
                Object op = serverBridge.dmr_get(getStateOp, ServerBridge.OP_FIELD_VALUE);
                serverBridge.dmr_set(op, ServerBridge.READ_ATTRIBUTE_OPERATION_FIELD_VALUE);
                Object name = serverBridge.dmr_get(getStateOp, ServerBridge.NAME_FIELD_VALUE);
                serverBridge.dmr_set(name, "server-state");
            }
            catch (Exception ex) {
                throw new ConfigGeneratorException(ex);
            }
            do {
                try {
                    Object response = serverBridge.mcc_execute(this.mcc, getStateOp);
                    if (serverBridge.dmr_isSuccessful(response).booleanValue()) {
                        Object result = serverBridge.dmr_get(response, ServerBridge.RESULT_FIELD_VALUE);
                        status = serverBridge.dmr_asString(result);
                    }
                }
                catch (Exception response) {
                    // empty catch block
                }
                if (!"starting".equals(status)) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ConfigGeneratorException("Interrupted while waiting for embedded server to start");
                }
            } while (System.nanoTime() < expired);
            if ("starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ConfigGeneratorException("Embedded server did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }

    void stopEmbedded() throws ConfigGeneratorException {
        if (this.forkEmbedded) {
            this.writeScript(STOP);
        } else {
            this.doStopEmbedded();
        }
    }

    protected void writeScript(String line) {
        this.scriptWriter.println(line);
    }
}

