/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;

public class ArtifactRecorder {
    protected static final String ARTIFACT_LIST_FILE = "artifacts.txt";
    private static final String SEPARATOR = "::";
    private final Path stagedDir;
    private final Path cacheDir;
    private final Path artifactList;
    private final HashMap<String, Path> cachedArtifacts = new HashMap();

    public ArtifactRecorder(Path stagedDir, Path cacheDir) throws IOException {
        this.stagedDir = stagedDir;
        this.cacheDir = cacheDir.isAbsolute() ? cacheDir : stagedDir.resolve(cacheDir);
        this.artifactList = this.cacheDir.resolve(ARTIFACT_LIST_FILE);
        this.initCacheDir();
    }

    private void initCacheDir() throws IOException {
        if (!Files.exists(this.cacheDir, new LinkOption[0])) {
            Files.createDirectories(this.cacheDir, new FileAttribute[0]);
        }
        Files.deleteIfExists(this.artifactList);
        Files.createFile(this.artifactList, new FileAttribute[0]);
    }

    public void record(MavenArtifact artifact, Path target) throws IOException {
        Path cachedPath;
        String coord = artifact.getCoordsAsString();
        if (this.cachedArtifacts.containsKey(coord) && (cachedPath = this.cachedArtifacts.get(coord)).toAbsolutePath().startsWith(this.cacheDir) && !cachedPath.equals(target)) {
            Files.delete(cachedPath);
        }
        this.cachedArtifacts.put(coord, target);
    }

    public void cache(MavenArtifact artifact, Path jarSrc) throws MavenUniverseException, IOException {
        if (!this.cachedArtifacts.containsKey(artifact.getCoordsAsString())) {
            IoUtils.copy((Path)jarSrc, (Path)this.cacheDir.resolve(artifact.getArtifactFileName()));
            this.record(artifact, this.cacheDir.resolve(artifact.getArtifactFileName()));
        }
    }

    public void writeCacheManifest() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Path> entry : this.cachedArtifacts.entrySet()) {
            String hash = HashUtils.hashFile((Path)entry.getValue());
            Path relativePath = this.stagedDir.relativize(entry.getValue());
            String universalPath = relativePath.toString().replace(File.separatorChar, '/');
            sb.append(entry.getKey()).append(SEPARATOR).append(hash).append(SEPARATOR).append(universalPath).append("\n");
        }
        Files.writeString(this.artifactList, (CharSequence)sb.toString(), new OpenOption[0]);
    }
}

