/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.PackageRuntime;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.WildFlyPackageTask;

public class FileAppender
implements WildFlyPackageTask {
    private String src;
    private String target;
    private String match;
    private boolean ignore = true;
    private boolean allMatches = true;
    private final List<String> lines = new ArrayList<String>();
    private String addToMatchingLine = null;

    public void setTarget(String target) {
        this.target = target;
    }

    public Pattern getMatch() {
        if (this.match == null) {
            return null;
        }
        return Pattern.compile(this.match);
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public void addLine(String line) {
        if (line == null) {
            this.lines.add("");
        } else {
            this.lines.add(line);
        }
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setSource(String src) {
        this.src = src;
    }

    public void setAddToMatchingLine(String addToMatchingLine) {
        this.addToMatchingLine = addToMatchingLine;
    }

    public void setAllMatches(boolean allMatches) {
        this.allMatches = allMatches;
    }

    @Override
    public void execute(WfInstallPlugin plugin, PackageRuntime pkg) throws ProvisioningException {
        if (this.target == null) {
            if (this.isIgnore()) {
                return;
            }
            throw new ProvisioningException("Target can't be null when appending content");
        }
        Path targetPath = plugin.getRuntime().getStagedDir().resolve(this.target);
        if (!Files.exists(targetPath, new LinkOption[0])) {
            if (this.isIgnore()) {
                return;
            }
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)targetPath));
        }
        try {
            if (this.src != null) {
                Path srcPath = plugin.getRuntime().getStagedDir().resolve(this.src);
                if (!Files.exists(srcPath, new LinkOption[0])) {
                    throw new ProvisioningException(Errors.pathDoesNotExist((Path)srcPath));
                }
                this.lines.clear();
                this.lines.addAll(Files.readAllLines(srcPath));
            }
            List<String> fileLines = Files.readAllLines(targetPath);
            ArrayList<Object> updatedLines = new ArrayList<Object>(this.lines.size() + 3);
            boolean found = false;
            for (String line : fileLines) {
                if ((this.allMatches || !found) && this.getMatch() != null && this.getMatch().matcher(line).find()) {
                    if (this.addToMatchingLine != null && !this.addToMatchingLine.isEmpty()) {
                        updatedLines.add(line + this.addToMatchingLine);
                    } else {
                        updatedLines.add(line);
                    }
                    for (int i = 0; i < this.lines.size(); ++i) {
                        updatedLines.add(this.lines.get(i));
                    }
                    continue;
                }
                updatedLines.add(line);
            }
            if (this.getMatch() == null) {
                updatedLines.addAll(this.lines);
            }
            Files.write(targetPath, updatedLines, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to append content to file %s", targetPath), e);
        }
    }
}

